/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.coordinator;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

final class SignerProperty {
    private final Bundle bundle;
    private final String pattern;

    public SignerProperty(String string) {
        this.pattern = string;
        this.bundle = null;
    }

    SignerProperty(Bundle bundle) {
        this.bundle = bundle;
        this.pattern = null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignerProperty)) {
            return false;
        }
        SignerProperty signerProperty = (SignerProperty)object;
        Bundle bundle = this.bundle != null ? this.bundle : signerProperty.bundle;
        String string = this.bundle != null ? signerProperty.pattern : this.pattern;
        Map map = bundle.getSignerCertificates(2);
        for (List list : map.values()) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (X509Certificate x509Certificate : list) {
                arrayList.add(x509Certificate.getSubjectDN().getName());
            }
            try {
                if (!FrameworkUtil.matchDistinguishedNameChain((String)string, arrayList)) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    boolean isBundleSigned() {
        if (this.bundle == null) {
            return false;
        }
        Map map = this.bundle.getSignerCertificates(2);
        return !map.isEmpty();
    }
}

