/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.subsystem;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.subsystem.SubsystemPermission;

final class SubsystemPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3906372644575328048L;
    private transient Map<String, SubsystemPermission> permissions = new HashMap<String, SubsystemPermission>();
    private boolean all_allowed;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof SubsystemPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        SubsystemPermission subsystemPermission = (SubsystemPermission)permission;
        if (subsystemPermission.subsystem != null) {
            throw new IllegalArgumentException("cannot add to collection: " + subsystemPermission);
        }
        String string = subsystemPermission.getName();
        SubsystemPermissionCollection subsystemPermissionCollection = this;
        synchronized (subsystemPermissionCollection) {
            Map<String, SubsystemPermission> map = this.permissions;
            SubsystemPermission subsystemPermission2 = map.get(string);
            if (subsystemPermission2 != null) {
                int n = subsystemPermission2.action_mask;
                int n2 = subsystemPermission.action_mask;
                if (n != n2) {
                    map.put(string, new SubsystemPermission(subsystemPermission2.filter, n | n2));
                }
            } else {
                map.put(string, subsystemPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<SubsystemPermission> collection;
        if (!(permission instanceof SubsystemPermission)) {
            return false;
        }
        SubsystemPermission subsystemPermission = (SubsystemPermission)permission;
        if (subsystemPermission.filter != null) {
            return false;
        }
        int n = 0;
        SubsystemPermissionCollection subsystemPermissionCollection = this;
        synchronized (subsystemPermissionCollection) {
            int n2;
            SubsystemPermission subsystemPermission2;
            Map<String, SubsystemPermission> object = this.permissions;
            if (this.all_allowed && (subsystemPermission2 = object.get("*")) != null && ((n |= subsystemPermission2.action_mask) & (n2 = subsystemPermission.action_mask)) == n2) {
                return true;
            }
            collection = object.values();
        }
        for (SubsystemPermission subsystemPermission3 : collection) {
            if (!subsystemPermission3.implies0(subsystemPermission, n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<SubsystemPermission> arrayList = new ArrayList<SubsystemPermission>(this.permissions.values());
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", this.permissions);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.permissions = hashMap = (HashMap)getField.get("permissions", null);
        this.all_allowed = getField.get("all_allowed", false);
    }
}

