/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.dto;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DTO {
    public String toString() {
        return DTO.appendValue(new StringBuilder(), new IdentityHashMap<Object, String>(), "#", this).toString();
    }

    private static StringBuilder appendDTO(StringBuilder stringBuilder, Map<Object, String> map, String string, DTO dTO) {
        stringBuilder.append("{");
        String string2 = "";
        for (Field field : dTO.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            stringBuilder.append(string2);
            String string3 = field.getName();
            DTO.appendString(stringBuilder, string3);
            stringBuilder.append(":");
            Object object = null;
            try {
                object = field.get(dTO);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            DTO.appendValue(stringBuilder, map, string + "/" + string3, object);
            string2 = ", ";
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    private static StringBuilder appendValue(StringBuilder stringBuilder, Map<Object, String> map, String string, Object object) {
        if (object == null) {
            return stringBuilder.append("null");
        }
        if (object instanceof String || object instanceof Character) {
            return DTO.appendString(stringBuilder, DTO.compress(object.toString()));
        }
        if (object instanceof Number || object instanceof Boolean) {
            return stringBuilder.append(object.toString());
        }
        String string2 = map.get(object);
        if (string2 != null) {
            stringBuilder.append("{\"$ref\":");
            DTO.appendString(stringBuilder, string2);
            stringBuilder.append("}");
            return stringBuilder;
        }
        map.put(object, string);
        if (object instanceof DTO) {
            return DTO.appendDTO(stringBuilder, map, string, (DTO)object);
        }
        if (object instanceof Map) {
            return DTO.appendMap(stringBuilder, map, string, (Map)object);
        }
        if (object instanceof List || object instanceof Set) {
            return DTO.appendIterable(stringBuilder, map, string, (Iterable)object);
        }
        if (object.getClass().isArray()) {
            return DTO.appendArray(stringBuilder, map, string, object);
        }
        return DTO.appendString(stringBuilder, DTO.compress(object.toString()));
    }

    private static StringBuilder appendArray(StringBuilder stringBuilder, Map<Object, String> map, String string, Object object) {
        stringBuilder.append("[");
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            DTO.appendValue(stringBuilder, map, string + "/" + i, Array.get(object, i));
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    private static StringBuilder appendIterable(StringBuilder stringBuilder, Map<Object, String> map, String string, Iterable<?> iterable) {
        stringBuilder.append("[");
        int n = 0;
        for (Object obj : iterable) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            DTO.appendValue(stringBuilder, map, string + "/" + n, obj);
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    private static StringBuilder appendMap(StringBuilder stringBuilder, Map<Object, String> map, String string, Map<?, ?> map2) {
        stringBuilder.append("{");
        String string2 = "";
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            stringBuilder.append(string2);
            String string3 = String.valueOf(entry.getKey());
            DTO.appendString(stringBuilder, string3);
            stringBuilder.append(":");
            Object obj = entry.getValue();
            DTO.appendValue(stringBuilder, map, string + "/" + string3, obj);
            string2 = ", ";
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    private static StringBuilder appendString(StringBuilder stringBuilder, CharSequence charSequence) {
        stringBuilder.append("\"");
        int n = stringBuilder.length();
        stringBuilder.append(charSequence);
        while (n < stringBuilder.length()) {
            char c = stringBuilder.charAt(n);
            if (c == '\"' || c == '\\') {
                stringBuilder.insert(n, '\\');
                n += 2;
                continue;
            }
            if (c < ' ') {
                stringBuilder.insert(n + 1, Integer.toHexString(c | 0x10000));
                stringBuilder.replace(n, n + 2, "\\u");
                n += 6;
                continue;
            }
            ++n;
        }
        stringBuilder.append("\"");
        return stringBuilder;
    }

    private static CharSequence compress(CharSequence charSequence) {
        int n = charSequence.length();
        if (n <= 21) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder(21);
        stringBuilder.append(charSequence, 0, 9);
        stringBuilder.append("...");
        stringBuilder.append(charSequence, n - 9, n);
        return stringBuilder;
    }
}

