/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.BundlePermissionCollection;

public final class BundlePermission
extends BasicPermission {
    private static final long serialVersionUID = 3257846601685873716L;
    public static final String PROVIDE = "provide";
    public static final String REQUIRE = "require";
    public static final String HOST = "host";
    public static final String FRAGMENT = "fragment";
    private static final int ACTION_PROVIDE = 1;
    private static final int ACTION_REQUIRE = 2;
    private static final int ACTION_HOST = 4;
    private static final int ACTION_FRAGMENT = 8;
    private static final int ACTION_ALL = 15;
    static final int ACTION_NONE = 0;
    private transient int action_mask;
    private volatile String actions = null;

    public BundlePermission(String string, String string2) {
        this(string, BundlePermission.parseActions(string2));
    }

    BundlePermission(String string, int n) {
        super(string);
        this.setTransients(n);
    }

    private synchronized void setTransients(int n) {
        if (n == 0 || (n & 0xF) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    synchronized int getActionsMask() {
        return this.action_mask;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 6 || cArray[n2 - 6] != 'p' && cArray[n2 - 6] != 'P' || cArray[n2 - 5] != 'r' && cArray[n2 - 5] != 'R' || cArray[n2 - 4] != 'o' && cArray[n2 - 4] != 'O' || cArray[n2 - 3] != 'v' && cArray[n2 - 3] != 'V' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 'd' && cArray[n2 - 1] != 'D' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 3;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'r' && cArray[n2 - 6] != 'R' || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 'q' && cArray[n2 - 4] != 'Q' || cArray[n2 - 3] != 'u' && cArray[n2 - 3] != 'U' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 'r' && cArray[n2 - 1] != 'R' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 2;
            } else if (!(n2 < 3 || cArray[n2 - 3] != 'h' && cArray[n2 - 3] != 'H' || cArray[n2 - 2] != 'o' && cArray[n2 - 2] != 'O' || cArray[n2 - 1] != 's' && cArray[n2 - 1] != 'S' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 4;
                n |= 4;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'f' && cArray[n2 - 7] != 'F' || cArray[n2 - 6] != 'r' && cArray[n2 - 6] != 'R' || cArray[n2 - 5] != 'a' && cArray[n2 - 5] != 'A' || cArray[n2 - 4] != 'g' && cArray[n2 - 4] != 'G' || cArray[n2 - 3] != 'm' && cArray[n2 - 3] != 'M' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'n' && cArray[n2 - 1] != 'N' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 8;
                n |= 8;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    @Override
    public boolean implies(Permission permission) {
        int n;
        if (!(permission instanceof BundlePermission)) {
            return false;
        }
        BundlePermission bundlePermission = (BundlePermission)permission;
        int n2 = this.getActionsMask();
        return (n2 & (n = bundlePermission.getActionsMask())) == n && super.implies(bundlePermission);
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if ((this.action_mask & 1) == 1) {
                stringBuffer.append(PROVIDE);
                bl = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(REQUIRE);
                bl = true;
            }
            if ((this.action_mask & 4) == 4) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(HOST);
                bl = true;
            }
            if ((this.action_mask & 8) == 8) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(FRAGMENT);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new BundlePermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BundlePermission)) {
            return false;
        }
        BundlePermission bundlePermission = (BundlePermission)object;
        return this.getActionsMask() == bundlePermission.getActionsMask() && this.getName().equals(bundlePermission.getName());
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(BundlePermission.parseActions(this.actions));
    }
}

