/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.ErrorExpression;
import com.icl.saxon.expr.ExpressionParser;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.output.Outputter;
import javax.xml.transform.TransformerException;

public abstract class Expression {
    protected StaticContext staticContext;

    public static Expression make(String string, StaticContext staticContext) throws XPathException {
        try {
            Expression expression = new ExpressionParser().parse(string, staticContext).simplify();
            expression.staticContext = staticContext;
            return expression;
        }
        catch (XPathException xPathException) {
            if (staticContext.forwardsCompatibleModeIsEnabled()) {
                return new ErrorExpression(xPathException);
            }
            throw xPathException;
        }
    }

    public Expression simplify() throws XPathException {
        return this;
    }

    public final void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public final StaticContext getStaticContext() {
        return this.staticContext;
    }

    public boolean containsReferences() throws XPathException {
        return (this.getDependencies() & 1) != 0;
    }

    public abstract Value evaluate(Context var1) throws XPathException;

    public boolean evaluateAsBoolean(Context context) throws XPathException {
        return this.evaluate(context).asBoolean();
    }

    public double evaluateAsNumber(Context context) throws XPathException {
        return this.evaluate(context).asNumber();
    }

    public String evaluateAsString(Context context) throws XPathException {
        return this.evaluate(context).asString();
    }

    public void outputStringValue(Outputter outputter, Context context) throws TransformerException {
        outputter.writeContent(this.evaluateAsString(context));
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws XPathException {
        Value value = this.evaluate(context);
        if (value instanceof NodeSetValue) {
            return (NodeSetValue)value;
        }
        throw new XPathException("The value is not a node-set");
    }

    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        Value value = this.evaluate(context);
        if (value instanceof NodeSetValue) {
            if (bl) {
                ((NodeSetValue)value).sort();
            }
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            return nodeEnumeration;
        }
        throw new XPathException("The value is not a node-set");
    }

    public abstract int getDataType();

    public boolean isContextDocumentNodeSet() {
        return false;
    }

    public boolean usesCurrent() {
        return (this.getDependencies() & 4) != 0;
    }

    public abstract int getDependencies();

    public abstract Expression reduce(int var1, Context var2) throws XPathException;

    public abstract void display(int var1);

    protected static String indent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }
}

