/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.charcode.UnicodeCharacterSet;
import com.icl.saxon.output.XMLEmitter;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class TEXTEmitter
extends XMLEmitter {
    private String mediaType = "text/plain";

    @Override
    public void startDocument() throws TransformerException {
        String string = this.outputProperties.getProperty("media-type");
        if (string != null) {
            this.mediaType = string;
        }
        if (this.characterSet == null) {
            this.characterSet = UnicodeCharacterSet.getInstance();
        }
        this.empty = true;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        for (int i = n; i < n + n2; ++i) {
            if (this.characterSet.inCharset(cArray[i])) continue;
            throw new TransformerException("Output character not available in this encoding (decimal " + cArray[i] + ")");
        }
        try {
            this.writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    @Override
    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
    }

    @Override
    public void endElement(int n) throws TransformerException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws TransformerException {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws TransformerException {
    }
}

