/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.TreeBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.helpers.AttributesImpl;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private boolean[] attributeChecked;
    private int numberOfAttributes;
    private boolean toplevel;
    private int[] namespaceCodes;

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.toplevel = this.getParentNode() instanceof XSLStyleSheet;
        StandardNames standardNames = this.getStandardNames();
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        int n = namePool.getURICode(this.resultNameCode);
        if (this.toplevel) {
            if (n == 0) {
                this.compileError("Top level elements must have a non-null namespace URI");
            }
        } else {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            boolean bl = false;
            if (this.getParent() instanceof LiteralResultElement && (this.namespaceList == null || this.namespaceList.length == 0) && n == namePool.getURICode(this.getParent().getFingerprint())) {
                bl = true;
            }
            if (bl) {
                for (int i = 0; i < this.attributeList.getLength(); ++i) {
                    if ((this.attributeList.getNameCode(i) >> 20 & 0xFF) == 0) continue;
                    bl = false;
                    break;
                }
            }
            this.namespaceCodes = bl ? new int[0] : this.getNamespaceCodes();
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            if (xSLStyleSheet.hasNamespaceAliases()) {
                for (n6 = 0; n6 < this.namespaceCodes.length; ++n6) {
                    short s = (short)(this.namespaceCodes[n6] & 0xFFFF);
                    n5 = xSLStyleSheet.getNamespaceAlias(s);
                    if (s == n5) continue;
                    n4 = this.namespaceCodes[n6] & 0xFFFF0000;
                    this.namespaceCodes[n6] = n4 | n5;
                }
                n6 = xSLStyleSheet.getNamespaceAlias((short)n);
                if (n6 != n) {
                    n = n6;
                    this.resultNameCode = namePool.allocate(this.getPrefix(), (short)n6, this.getLocalName());
                }
            }
            n6 = this.attributeList.getLength();
            this.attributeNames = new int[n6];
            this.attributeValues = new Expression[n6];
            this.attributeChecked = new boolean[n6];
            short[] sArray = new short[n6];
            this.numberOfAttributes = 0;
            for (n5 = 0; n5 < n6; ++n5) {
                Expression expression;
                String string;
                short s;
                n3 = n4 = this.attributeList.getNameCode(n5);
                n2 = n4 & 0xFFFFF;
                short s2 = namePool.getURICode(n4);
                if (n2 == standardNames.XSL_USE_ATTRIBUTE_SETS) {
                    this.findAttributeSets(this.attributeList.getValue(n5));
                    continue;
                }
                if (n2 == standardNames.XSL_EXTENSION_ELEMENT_PREFIXES || n2 == standardNames.XSL_EXCLUDE_RESULT_PREFIXES || n2 == standardNames.XSL_VERSION) continue;
                if (s2 == 2) {
                    this.compileError("Unknown XSL attribute " + namePool.getDisplayName(n4));
                }
                if (s2 != 0 && (s = xSLStyleSheet.getNamespaceAlias(s2)) != s2) {
                    String string2 = namePool.getDisplayName(n4);
                    string = Name.getPrefix(string2);
                    String string3 = Name.getLocalName(string2);
                    String string4 = namePool.getURIFromNamespaceCode(s);
                    n3 = namePool.allocate(string, string4, string3);
                    s2 = s;
                }
                this.attributeNames[this.numberOfAttributes] = n3;
                sArray[this.numberOfAttributes] = s2;
                this.attributeValues[this.numberOfAttributes] = expression = this.makeAttributeValueTemplate(this.attributeList.getValue(n5));
                this.attributeChecked[this.numberOfAttributes] = false;
                boolean bl2 = false;
                if (expression instanceof StringValue) {
                    string = ((StringValue)expression).asString();
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&' && c != '\"') continue;
                        bl2 = true;
                        break;
                    }
                    this.attributeChecked[this.numberOfAttributes] = !bl2;
                }
                ++this.numberOfAttributes;
            }
            for (n5 = 0; n5 < this.namespaceCodes.length; ++n5) {
                n4 = (short)(this.namespaceCodes[n5] & 0xFFFF);
                if (!this.isExcludedNamespace((short)n4)) continue;
                n3 = 1;
                if (n4 == n) {
                    n3 = 0;
                }
                for (n2 = 0; n2 < this.numberOfAttributes; ++n2) {
                    if (n4 != sArray[n2]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                this.namespaceCodes[n5] = -1;
            }
        }
    }

    @Override
    protected void validateChildren() throws TransformerConfigurationException {
        if (!this.toplevel) {
            super.validateChildren();
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
        int n;
        if (this.toplevel) {
            return;
        }
        Outputter outputter = context.getOutputter();
        outputter.writeStartTag(this.resultNameCode);
        for (n = 0; n < this.namespaceCodes.length; ++n) {
            if (this.namespaceCodes[n] == -1) continue;
            outputter.writeNamespaceDeclaration(this.namespaceCodes[n]);
        }
        this.processAttributeSets(context);
        for (n = 0; n < this.numberOfAttributes; ++n) {
            int n2 = this.attributeNames[n];
            String string = this.attributeValues[n].evaluateAsString(context);
            outputter.writeAttribute(n2, string, this.attributeChecked[n]);
        }
        this.processChildren(context);
        outputter.writeEndTag(this.resultNameCode);
    }

    public DocumentImpl makeStyleSheet(PreparedStyleSheet preparedStyleSheet) throws TransformerConfigurationException {
        NamePool namePool = this.getNamePool();
        StandardNames standardNames = this.getStandardNames();
        String string = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (string == null) {
            String string2 = this.getLocalName().equals("stylesheet") || this.getLocalName().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string2);
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        String string3 = this.getAttributeValue(standardNames.XSL_VERSION);
        if (string3 == null) {
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException("Literal Result Element As Stylesheet: xsl:version attribute is missing");
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        try {
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setDocumentLocator(null);
            treeBuilder.setNamePool(namePool);
            treeBuilder.setNodeFactory(((DocumentImpl)this.getParentNode()).getNodeFactory());
            treeBuilder.setSystemId(this.getSystemId());
            treeBuilder.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "version", "version", "CDATA", string3);
            int[] nArray = new int[]{namePool.getNamespaceCode("xsl", "http://www.w3.org/1999/XSL/Transform")};
            int n = namePool.allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "stylesheet");
            treeBuilder.startElement(n, attributesImpl, nArray, 1);
            int n2 = namePool.allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "template");
            attributesImpl.clear();
            attributesImpl.addAttribute("", "match", "match", "CDATA", "/");
            treeBuilder.startElement(n2, attributesImpl, nArray, 0);
            treeBuilder.graftElement(this);
            treeBuilder.endElement(n2);
            treeBuilder.endElement(n);
            treeBuilder.endDocument();
            return (DocumentImpl)treeBuilder.getCurrentDocument();
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }
}

