/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLOtherwise;
import com.icl.saxon.style.XSLWhen;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean doesPostProcessing() {
        return false;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            this.checkUnknownAttribute(n);
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        NodeImpl nodeImpl = null;
        for (NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild(); nodeImpl2 != null; nodeImpl2 = (NodeImpl)nodeImpl2.getNextSibling()) {
            if (nodeImpl2 instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.compileError("xsl:otherwise must come last");
                }
                nodeImpl = nodeImpl2;
                continue;
            }
            if (nodeImpl2 instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    this.compileError("Only one xsl:otherwise allowed in an xsl:choose");
                    continue;
                }
                this.otherwise = (StyleElement)nodeImpl2;
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed here");
        }
        if (nodeImpl == null) {
            this.compileError("xsl:choose must contain at least one xsl:when");
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
        boolean bl = context.getController().isTracing();
        StyleElement styleElement = (StyleElement)this.getFirstChild();
        while (styleElement != null) {
            boolean bl2 = styleElement instanceof XSLWhen ? ((XSLWhen)styleElement).getCondition().evaluateAsBoolean(context) : true;
            if (bl2) {
                if (bl) {
                    TraceListener traceListener = context.getController().getTraceListener();
                    traceListener.enter(styleElement, context);
                    styleElement.process(context);
                    traceListener.leave(styleElement, context);
                } else {
                    styleElement.process(context);
                }
                styleElement = null;
                continue;
            }
            styleElement = (StyleElement)styleElement.getNextSibling();
        }
    }
}

