/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;

final class PrecedingSiblingEnumeration
implements AxisEnumeration {
    TinyDocumentImpl document;
    TinyNodeImpl startNode;
    int nextNodeNr;
    int depth;
    NodeTest test;
    TinyNodeImpl parentNode;
    int last = -1;

    protected PrecedingSiblingEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest) {
        this.document = tinyDocumentImpl;
        this.document.ensurePriorIndex();
        this.test = nodeTest;
        this.startNode = tinyNodeImpl;
        this.nextNodeNr = tinyNodeImpl.nodeNr;
        this.depth = tinyDocumentImpl.depth[this.nextNodeNr];
        this.parentNode = tinyNodeImpl.parent;
        this.advance();
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextNodeNr >= 0;
    }

    @Override
    public NodeInfo nextElement() {
        TinyNodeImpl tinyNodeImpl = this.document.getNode(this.nextNodeNr);
        tinyNodeImpl.setParentNode(this.parentNode);
        this.advance();
        return tinyNodeImpl;
    }

    private void advance() {
        do {
            this.nextNodeNr = this.document.prior[this.nextNodeNr];
        } while (this.nextNodeNr >= 0 && !this.test.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr]));
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isReverseSorted() {
        return true;
    }

    @Override
    public boolean isPeer() {
        return true;
    }

    @Override
    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        PrecedingSiblingEnumeration precedingSiblingEnumeration = new PrecedingSiblingEnumeration(this.document, this.startNode, this.test);
        this.last = 0;
        while (precedingSiblingEnumeration.hasMoreElements()) {
            precedingSiblingEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

