/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.DieManager;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetDiceButton
extends DiceButton
implements GameComponent,
CommandEncoder {
    protected static DieManager dieManager;
    private static final String COMMAND_PREFIX = "SEMAIL\t";
    public static final String DETAILS = "rollDetails";

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.InternetDiceButton.component_type");
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class<?>[] classArray = super.getAttributeTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != DiceButton.ReportFormatConfig.class) continue;
            classArray[i] = InternetReportFormatConfig.class;
        }
        return classArray;
    }

    @Override
    protected void DR() {
        this.reportFormat.setProperty("name", this.getLocalizedConfigureName());
        dieManager.roll(this.nDice, this.nSides, this.plus, this.reportTotal, this.getLocalizedConfigureName(), this.reportFormat);
    }

    @Override
    public void addTo(Buildable buildable) {
        this.initDieManager();
        dieManager.addDieButton(this);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        super.addTo(buildable);
    }

    protected void initDieManager() {
        if (dieManager == null) {
            dieManager = new DieManager();
            dieManager.build(null);
        }
    }

    @Override
    public void removeFrom(Buildable buildable) {
        dieManager.removeDieButton(this);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        super.removeFrom(buildable);
    }

    @Override
    public void setup(boolean bl) {
    }

    @Override
    public Command getRestoreCommand() {
        return new SetSecondaryEmail(dieManager.getServer().getSecondaryEmail());
    }

    @Override
    public Command decode(String string) {
        SetSecondaryEmail setSecondaryEmail = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            setSecondaryEmail = new SetSecondaryEmail(string.substring(COMMAND_PREFIX.length()));
        }
        return setSecondaryEmail;
    }

    @Override
    public String encode(Command command) {
        String string = null;
        if (command instanceof SetSecondaryEmail) {
            string = COMMAND_PREFIX + ((SetSecondaryEmail)command).msg;
        }
        return string;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "InternetDiceButton");
    }

    private static class SetSecondaryEmail
    extends Command {
        private String msg;

        private SetSecondaryEmail(String string) {
            this.msg = string;
        }

        protected void executeCommand() {
            dieManager.setSecondaryEmail(this.msg);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class InternetReportFormatConfig
    extends DiceButton.ReportFormatConfig {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            FormattedStringConfigurer formattedStringConfigurer = (FormattedStringConfigurer)super.getConfigurer(autoConfigurable, string, string2);
            formattedStringConfigurer.setOptions(ArrayUtils.append(formattedStringConfigurer.getOptions(), InternetDiceButton.DETAILS));
            return formattedStringConfigurer;
        }
    }
}

