/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.io.IOUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSaver
extends AbstractConfigurable {
    protected static final String HOTKEY = "hotkey";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String TOOLTIP = "tooltip";
    protected static final String ICON_NAME = "icon";
    protected Map map;
    protected LaunchButton launch;

    public TextSaver() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextSaver.this.apply();
            }
        };
        this.launch = new LaunchButton("Save Text", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(TOOLTIP, "Save map contents as plain text file");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, ICON_NAME, HOTKEY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    @Override
    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().add(this.launch);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().remove(this.launch);
        this.map.getToolBar().revalidate();
    }

    public void apply() {
        switch (JOptionPane.showConfirmDialog(null, "Write contents as seen by opponents?", "", 0)) {
            case 1: {
                this.writeMapAsText();
                break;
            }
            case 0: {
                String string = GameModule.getUserId();
                GameModule.setUserId("yendoR117");
                this.writeMapAsText();
                GameModule.setUserId(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMapAsText() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        if (fileChooser.showSaveDialog(this.map.getView()) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (GamePiece gamePiece : this.map.getPieces()) {
                String string = gamePiece.getName();
                if (string.length() <= 0) continue;
                printWriter.println(this.map.locationName(gamePiece.getPosition()) + ": " + string);
            }
            printWriter.close();
            IOUtils.closeQuietly((Writer)printWriter);
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, file);
        }
        finally {
            IOUtils.closeQuietly(printWriter);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "TextCapture");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.TextCapture.component_type");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((TextSaver)autoConfigurable).launch.getAttributeValueString(TextSaver.ICON_NAME));
        }
    }
}

