/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.tools.PropertiesEncoder;
import java.io.IOException;
import java.util.Properties;
import org.litesoft.p2pchat.PeerInfo;

public class P2PPlayer
extends SimplePlayer {
    private static final String ID = "id";
    private static final String ROOM = "room";
    private PeerInfo info;
    private Properties props;

    public P2PPlayer(PeerInfo peerInfo) {
        this.info = peerInfo;
        if (peerInfo.getChatName() != null) {
            try {
                this.props = new PropertiesEncoder(peerInfo.getChatName()).getProperties();
                this.setStats();
            }
            catch (IOException iOException) {
                this.props = new Properties();
                this.setProps();
            }
        } else {
            this.props = new Properties();
            this.setProps();
        }
    }

    public void setStats(Player player) {
        this.setName(player.getName());
        this.setStatus(player.getStatus());
        this.setId(player.getId());
        this.setProps();
    }

    private void setProps() {
        SimpleStatus simpleStatus = (SimpleStatus)this.status;
        this.props.put("name", this.getName());
        this.props.put("looking", String.valueOf(simpleStatus.isLooking()));
        this.props.put("away", String.valueOf(simpleStatus.isAway()));
        this.props.put("profile", simpleStatus.getProfile());
        this.props.put("ip", simpleStatus.getIp());
        this.props.put("client", simpleStatus.getClient());
        this.props.put("moduleVersion", simpleStatus.getModuleVersion());
        this.props.put("crc", simpleStatus.getCrc());
        this.info.setChatName(new PropertiesEncoder(this.props).getStringValue());
    }

    public void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    private void setStats() {
        this.setName(this.props.getProperty("name", "???"));
        this.setStatus(new SimpleStatus("true".equals(this.props.getProperty("looking")), "true".equals(this.props.getProperty("away")), this.props.getProperty("profile", ""), this.props.getProperty("client", ""), this.props.getProperty("ip", ""), this.props.getProperty("moduleVersion", ""), this.props.getProperty("crc", "")));
    }

    public String getRoom() {
        return this.props.getProperty(ROOM);
    }

    public void setRoom(String string) {
        this.props.put(ROOM, string);
        this.setProps();
    }

    public String getId() {
        return this.props.getProperty(ID);
    }

    public void setId(String string) {
        this.props.put(ID, string);
        this.setProps();
    }

    public boolean equals(Object object) {
        if (object instanceof P2PPlayer) {
            P2PPlayer p2PPlayer = (P2PPlayer)object;
            return this.getId() == null ? this.info.equals(p2PPlayer.info) : this.getId().equals(p2PPlayer.getId());
        }
        return false;
    }

    public PeerInfo getInfo() {
        return this.info;
    }

    public String summary() {
        return this.getName() + " [looking = " + ((SimpleStatus)this.status).isLooking() + ", away = " + ((SimpleStatus)this.getStatus()).isAway() + ", room = " + this.props.getProperty(ROOM) + ", host = " + this.getInfo().getAddresses() + "]";
    }
}

