/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.command.Command;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.GamePiece;
import VASSAL.counters.StateMergeable;

public class ChangePiece
extends Command {
    protected String newState;
    protected String oldState;
    private String id;
    private Command undo;

    public ChangePiece(String string, String string2, String string3) {
        this.id = string;
        this.newState = string3;
        this.oldState = string2;
    }

    @Deprecated
    public ChangePiece(String string, String string2) {
        this(string, null, string2);
    }

    protected void executeCommand() {
        GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(this.id);
        if (gamePiece != null) {
            BoundsTracker boundsTracker = new BoundsTracker();
            boundsTracker.addPiece(gamePiece);
            if (this.oldState != null) {
                if (gamePiece instanceof StateMergeable) {
                    ((StateMergeable)((Object)gamePiece)).mergeState(this.newState, this.oldState);
                } else {
                    gamePiece.setState(this.newState);
                }
            } else {
                this.oldState = gamePiece.getState();
                gamePiece.setState(this.newState);
            }
            boundsTracker.addPiece(gamePiece);
            boundsTracker.repaint();
            if (gamePiece.getMap() != null && GlobalOptions.getInstance().centerOnOpponentsMove() && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible"))) {
                gamePiece.getMap().ensureVisible(gamePiece.getMap().selectionBoundsOf(gamePiece));
            }
        }
    }

    public Command append(Command command) {
        Command command2 = this;
        Command[] commandArray = this.getSubCommands();
        if (commandArray.length > 0) {
            command2 = commandArray[commandArray.length - 1];
        }
        if (command instanceof ChangePiece && command2 instanceof ChangePiece && ((ChangePiece)command).id != null && ((ChangePiece)command).id.equals(command2.id) && ((ChangePiece)command).newState != null) {
            command2.newState = ((ChangePiece)command).newState;
            commandArray = command.getSubCommands();
            for (int i = 0; i < commandArray.length; ++i) {
                this.append(commandArray[i]);
            }
            return this;
        }
        return super.append(command);
    }

    protected Command myUndoCommand() {
        if (this.undo == null && this.oldState != null) {
            this.undo = new ChangePiece(this.id, this.newState, this.oldState);
        }
        return this.undo;
    }

    public String getId() {
        return this.id;
    }

    public String getNewState() {
        return this.newState;
    }

    public String getOldState() {
        return this.oldState;
    }

    public boolean isNull() {
        return this.newState.equals(this.oldState) && this.isAtomic();
    }

    public String getDetails() {
        return "id=" + this.id + ",oldState=" + this.oldState + ",newState=" + this.newState;
    }
}

