/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PieceEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassPieceDefiner
extends PieceDefiner {
    private static final long serialVersionUID = 1L;
    protected List<Entry> definers = new ArrayList<Entry>();

    public MassPieceDefiner(Configurable configurable) {
        this.changed = false;
        this.init(configurable);
        if (!this.definers.isEmpty()) {
            this.setPiece(this.definers.get(0).slot.getPiece());
            List<Class<? extends GamePiece>> list = this.getTemplate();
            for (int i = 0; i < this.definers.size(); ++i) {
                GamePiece gamePiece = this.definers.get(i).definer.getPiece();
                if (this.matchesTemplate(gamePiece, list)) continue;
                this.definers.remove(i--);
            }
        }
    }

    private void init(Configurable configurable) {
        Object object;
        if (configurable instanceof PieceSlot) {
            object = new Def();
            ((PieceDefiner)object).setPiece(((PieceSlot)configurable).getPiece());
            this.definers.add(new Entry((PieceSlot)configurable, (PieceDefiner)object));
        }
        object = configurable.getConfigureComponents();
        for (int i = 0; i < ((Configurable[])object).length; ++i) {
            this.init((Configurable)object[i]);
        }
    }

    private List<Class<? extends GamePiece>> getTemplate() {
        GamePiece gamePiece = this.definers.get(0).definer.getPiece();
        ArrayList<Class<? extends GamePiece>> arrayList = new ArrayList<Class<? extends GamePiece>>();
        while (gamePiece instanceof Decorator) {
            arrayList.add(gamePiece.getClass());
            gamePiece = ((Decorator)gamePiece).piece;
        }
        arrayList.add(gamePiece.getClass());
        return arrayList;
    }

    private boolean matchesTemplate(GamePiece gamePiece, List<Class<? extends GamePiece>> list) {
        Iterator<Class<? extends GamePiece>> iterator = list.iterator();
        while (gamePiece instanceof Decorator && iterator.hasNext()) {
            if (gamePiece.getClass() != iterator.next()) {
                return false;
            }
            gamePiece = ((Decorator)gamePiece).piece;
        }
        return iterator.hasNext() ? gamePiece.getClass() == iterator.next() && !iterator.hasNext() : false;
    }

    @Override
    protected void addTrait(Decorator decorator) {
        super.addTrait(decorator);
        for (Entry entry : this.definers) {
            entry.definer.addTrait(decorator);
        }
    }

    @Override
    protected void removeTrait(int n) {
        super.removeTrait(n);
        for (Entry entry : this.definers) {
            entry.definer.removeTrait(n);
        }
    }

    @Override
    protected void moveDecoratorUp(int n) {
        super.moveDecoratorUp(n);
        for (Entry entry : this.definers) {
            entry.definer.moveDecoratorUp(n);
        }
    }

    @Override
    protected void moveDecoratorDown(int n) {
        super.moveDecoratorDown(n);
        for (Entry entry : this.definers) {
            entry.definer.moveDecoratorDown(n);
        }
    }

    @Override
    protected void paste() {
        super.paste();
        for (Entry entry : this.definers) {
            entry.definer.paste();
        }
    }

    @Override
    protected boolean edit(int n) {
        boolean bl = super.edit(n);
        for (Entry entry : this.definers) {
            entry.definer.edit(n);
        }
        return bl;
    }

    public void save() {
        for (Entry entry : this.definers) {
            entry.slot.setPiece(entry.definer.getPiece());
        }
    }

    private class Def
    extends PieceDefiner {
        private static final long serialVersionUID = 1L;

        private Def() {
        }

        protected boolean edit(int n) {
            Object e = MassPieceDefiner.this.inUseModel.elementAt(n);
            if (!(e instanceof EditablePiece)) {
                return false;
            }
            PieceEditor pieceEditor = ((EditablePiece)e).getEditor();
            EditablePiece editablePiece = (EditablePiece)this.inUseModel.elementAt(n);
            editablePiece.mySetType(pieceEditor.getType());
            if (editablePiece instanceof Decorator) {
                ((Decorator)((Object)editablePiece)).mySetState(pieceEditor.getState());
            } else {
                editablePiece.setState(pieceEditor.getState());
            }
            return true;
        }
    }

    private static class Entry {
        private PieceSlot slot;
        private PieceDefiner definer;

        private Entry(PieceSlot pieceSlot, PieceDefiner pieceDefiner) {
            this.slot = pieceSlot;
            this.definer = pieceDefiner;
        }
    }
}

