/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class LocaleConfigurer
extends Configurer {
    protected static final String ANY_COUNTRY = "<Any Country>";
    protected Box panel;
    protected static Map<String, String> languages = new HashMap<String, String>();
    protected static String[] languageList;
    protected static Map<String, String> countries;
    protected static String[] countryList;
    protected JComboBox langBox;
    protected JComboBox countryBox;

    public LocaleConfigurer(String string, String string2) {
        this(string, string2, "");
    }

    public LocaleConfigurer(String string, String string2, Locale locale) {
        super(string, string2);
        this.setValue(locale);
    }

    public LocaleConfigurer(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setValue(string3);
    }

    public String getValueString() {
        return (String)this.value;
    }

    public Locale getValueLocale() {
        return LocaleConfigurer.stringToLocale((String)this.value);
    }

    public void setValue(Locale locale) {
        this.setValue(LocaleConfigurer.localeToString(locale));
    }

    public void setValue(String string) {
        this.getControls();
        if (!this.noUpdate && this.langBox != null && this.countryBox != null) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
            this.setLanguage(decoder.nextToken(Locale.getDefault().getLanguage()));
            this.setCountry(decoder.nextToken(""));
        }
        this.setValue((Object)string);
    }

    protected void setLanguage(String string) {
        String string2 = new Locale(string, "").getDisplayLanguage(Locale.getDefault());
        this.langBox.setSelectedItem(string2);
    }

    protected void setCountry(String string) {
        String string2 = string.length() == 0 ? ANY_COUNTRY : new Locale(Locale.getDefault().getLanguage(), string).getDisplayCountry(Locale.getDefault());
        this.countryBox.setSelectedItem(string2);
    }

    public Component getControls() {
        if (this.panel == null) {
            this.panel = Box.createHorizontalBox();
            this.langBox = new JComboBox<String>(this.getLanguageList());
            this.langBox.setSelectedItem(Locale.getDefault().getDisplayLanguage());
            this.langBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LocaleConfigurer.this.updateValue();
                }
            });
            this.panel.add(new JLabel("Language:  "));
            this.panel.add(this.langBox);
            this.countryBox = new JComboBox<String>(this.getCountryList());
            this.countryBox.setSelectedItem(ANY_COUNTRY);
            this.countryBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LocaleConfigurer.this.updateValue();
                }
            });
            this.panel.add(new JLabel("  Country:  "));
            this.panel.add(this.countryBox);
        }
        return this.panel;
    }

    protected void updateValue() {
        String string = languages.get(this.langBox.getSelectedItem());
        String string2 = countries.get(this.countryBox.getSelectedItem());
        this.setValue(string + "," + string2);
    }

    protected String[] getLanguageList() {
        if (languageList == null) {
            String[] stringArray = Locale.getISOLanguages();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = new Locale(stringArray[i]).getDisplayLanguage(Locale.getDefault());
                languages.put(string, stringArray[i]);
                arrayList.add(string);
            }
            Collections.sort(arrayList, Collator.getInstance(Locale.getDefault()));
            languageList = arrayList.toArray(new String[arrayList.size()]);
        }
        return languageList;
    }

    protected String[] getCountryList() {
        if (countryList == null) {
            String[] stringArray = Locale.getISOCountries();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = new Locale("en", stringArray[i]).getDisplayCountry(Locale.getDefault());
                countries.put(string, stringArray[i]);
                arrayList.add(string);
            }
            Collections.sort(arrayList, Collator.getInstance(Locale.getDefault()));
            countries.put(ANY_COUNTRY, "");
            arrayList.add(0, ANY_COUNTRY);
            countryList = arrayList.toArray(new String[arrayList.size()]);
        }
        return countryList;
    }

    public static Locale stringToLocale(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        return new Locale(decoder.nextToken(""), decoder.nextToken(""));
    }

    public static String localeToString(Locale locale) {
        return locale.getLanguage() + "," + locale.getCountry();
    }

    static {
        countries = new HashMap<String, String>();
    }
}

