/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.Info;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.PrefsEditor;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;

public class Prefs
implements Closeable {
    public static final String MODULES_DIR_KEY = "modulesDir";
    public static final String DISABLE_D3D = "disableD3d";
    private static Prefs globalPrefs;
    private Map<String, Configurer> options = new HashMap<String, Configurer>();
    private Properties storedValues = new Properties();
    private PrefsEditor editor;
    private File file;

    public Prefs(PrefsEditor prefsEditor, String string) {
        this(prefsEditor, new File(Info.getPrefsDir(), Prefs.sanitize(string)));
    }

    protected Prefs(PrefsEditor prefsEditor, File file) {
        this.editor = prefsEditor;
        this.file = file;
        this.read();
        Enumeration<Object> enumeration = this.storedValues.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.storedValues.getProperty(string);
            Configurer configurer = this.options.get(string);
            if (configurer == null) continue;
            configurer.setValue(string2);
        }
        prefsEditor.addPrefs(this);
    }

    public PrefsEditor getEditor() {
        return this.editor;
    }

    public File getFile() {
        return this.file;
    }

    public void addOption(Configurer configurer) {
        this.addOption(Resources.getString("Prefs.general_tab"), configurer);
    }

    public void addOption(String string, Configurer configurer) {
        this.addOption(string, configurer, null);
    }

    public void addOption(String string, Configurer configurer, String string2) {
        if (configurer != null && this.options.get(configurer.getKey()) == null) {
            this.options.put(configurer.getKey(), configurer);
            String string3 = this.storedValues.getProperty(configurer.getKey());
            if (string3 != null) {
                configurer.setValue(string3);
                string2 = null;
            }
            if (string != null && configurer.getControls() != null) {
                this.editor.addOption(string, configurer, string2);
            }
        }
    }

    public void setValue(String string, Object object) {
        this.options.get(string).setValue(object);
    }

    public Configurer getOption(String string) {
        return this.options.get(string);
    }

    public Object getValue(String string) {
        Configurer configurer = this.options.get(string);
        return configurer == null ? null : configurer.getValue();
    }

    public String getStoredValue(String string) {
        return this.storedValues.getProperty(string);
    }

    public static String sanitize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            if (48 <= n && n <= 57 || 65 <= n && n <= 90 || 97 <= n && n <= 122) {
                stringBuilder.append((char)n);
                continue;
            }
            stringBuilder.append('_').append(Integer.toHexString(n).toUpperCase()).append('_');
        }
        return stringBuilder.toString();
    }

    protected void read() {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            this.storedValues.clear();
            this.storedValues.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOUtils.closeQuietly(bufferedInputStream);
        }
        catch (IOException iOException) {
            try {
                ReadErrorDialog.errorNoI18N(iOException, this.file);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        this.storedValues.clear();
        if (!Info.getPrefsDir().exists()) {
            FileUtils.forceMkdir((File)Info.getPrefsDir());
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.file, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            FileLock fileLock = fileChannel.lock();
            InputStream inputStream = Channels.newInputStream(fileChannel);
            this.storedValues.load(inputStream);
            for (Configurer configurer : this.options.values()) {
                String string = configurer.getValueString();
                if (string == null) continue;
                this.storedValues.put(configurer.getKey(), string);
            }
            fileChannel.truncate(0L);
            fileChannel.position(0L);
            OutputStream outputStream = Channels.newOutputStream(fileChannel);
            this.storedValues.store(outputStream, null);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(randomAccessFile);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)randomAccessFile);
    }

    public void write() throws IOException {
        this.save();
    }

    public void close() throws IOException {
        this.save();
        if (this == globalPrefs) {
            globalPrefs = null;
        }
    }

    public static Prefs getGlobalPrefs() {
        if (globalPrefs == null) {
            PrefsEditor prefsEditor = new PrefsEditor();
            globalPrefs = new Prefs(prefsEditor, new File(Info.getPrefsDir(), "V_Global"));
            DirectoryConfigurer directoryConfigurer = new DirectoryConfigurer(MODULES_DIR_KEY, null);
            directoryConfigurer.setValue(new File(System.getProperty("user.home")));
            globalPrefs.addOption(null, directoryConfigurer);
        }
        return globalPrefs;
    }

    public static void initSharedGlobalPrefs() {
        BooleanConfigurer booleanConfigurer;
        Prefs.getGlobalPrefs();
        if (SystemUtils.IS_OS_WINDOWS) {
            booleanConfigurer = new BooleanConfigurer(DISABLE_D3D, Resources.getString("Prefs.disable_d3d"), Boolean.FALSE);
            globalPrefs.addOption(booleanConfigurer);
        }
        booleanConfigurer = new BooleanConfigurer("welcomeWizard", Resources.getString("WizardSupport.ShowWizard"), Boolean.TRUE);
        globalPrefs.addOption(booleanConfigurer);
    }
}

