/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.property;

import VASSAL.property.Property;
import VASSAL.property.PropertyContainer;
import VASSAL.property.PropertyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePropertyContainer<V>
implements PropertyContainer {
    protected final Property<V> prop;
    protected V value;
    protected final CopyOnWriteArrayList<PropertyListener<Object>> listeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<PropertyListener<? super V>> plisteners = new CopyOnWriteArrayList();

    public SinglePropertyContainer(Property<V> property, V v) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (v == null) {
            throw new IllegalArgumentException();
        }
        this.prop = property;
        this.value = v;
    }

    @Override
    public Set<Property<?>> getProperties() {
        return Collections.singleton(this.prop);
    }

    @Override
    public <T> void setValue(Property<T> property, T t) {
        if (!this.prop.equals(property)) {
            throw new IllegalArgumentException();
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (this.value.equals(t)) {
            return;
        }
        V v = this.value;
        this.value = t;
        for (PropertyListener<Object> propertyListener : this.listeners) {
            propertyListener.propertyChanged(this, this.prop, v, this.value);
        }
        for (PropertyListener<Object> propertyListener : this.plisteners) {
            propertyListener.propertyChanged(this, this.prop, v, this.value);
        }
    }

    @Override
    public <T> T getValue(Property<T> property) {
        if (!this.prop.equals(property)) {
            throw new IllegalArgumentException();
        }
        return (T)this.value;
    }

    @Override
    public void addPropertyListener(PropertyListener<Object> propertyListener) {
        this.listeners.add(propertyListener);
    }

    @Override
    public <T> void addPropertyListener(Property<T> property, PropertyListener<? super T> propertyListener) {
        if (!this.prop.equals(property)) {
            throw new IllegalArgumentException();
        }
        this.plisteners.add(propertyListener);
    }

    @Override
    public void removePropertyListener(PropertyListener<Object> propertyListener) {
        this.listeners.remove(propertyListener);
    }

    @Override
    public <T> void removePropertyListener(Property<T> property, PropertyListener<? super T> propertyListener) {
        if (!this.prop.equals(property)) {
            throw new IllegalArgumentException();
        }
        this.plisteners.remove(propertyListener);
    }

    @Override
    public List<PropertyListener<Object>> getPropertyListeners() {
        return this.listeners.isEmpty() ? Collections.emptyList() : new ArrayList<PropertyListener<Object>>(this.listeners);
    }

    @Override
    public <T> List<PropertyListener<? super T>> getPropertyListeners(Property<T> property) {
        if (!this.prop.equals(property)) {
            throw new IllegalArgumentException();
        }
        return this.plisteners.isEmpty() ? Collections.emptyList() : new ArrayList<PropertyListener<V>>(this.plisteners);
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public <T> boolean hasListeners(Property<T> property) {
        if (!this.prop.equals(property)) {
            throw new IllegalArgumentException();
        }
        return !this.plisteners.isEmpty();
    }
}

