/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.PropertyMatchExpression;
import VASSAL.script.expression.SinglePropertyExpression;
import VASSAL.script.expression.StringExpression;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression {
    private String expression;

    public void setExpression(String string) {
        this.expression = string;
    }

    public String getExpression() {
        return this.expression;
    }

    public abstract String evaluate(PropertySource var1, Map<String, String> var2, boolean var3) throws ExpressionException;

    public String evaluate() throws ExpressionException {
        return this.evaluate(null, null, false);
    }

    public String evaluate(PropertySource propertySource) throws ExpressionException {
        return this.evaluate(propertySource, null, false);
    }

    public String evaluate(PropertySource propertySource, boolean bl) throws ExpressionException {
        return this.evaluate(propertySource, null, bl);
    }

    public String evaluate(boolean bl) throws ExpressionException {
        return this.evaluate(null, null, bl);
    }

    public PieceFilter getFilter(PropertySource propertySource) {
        return new PieceFilter(){

            public boolean accept(GamePiece gamePiece) {
                return true;
            }
        };
    }

    public PieceFilter getFilter() {
        return this.getFilter(GameModule.getGameModule());
    }

    public abstract String toBeanShellString();

    public static Expression createExpression(String string) {
        if (string == null || string.trim().length() == 0) {
            return new NullExpression();
        }
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            return BeanShellExpression.createExpression(string);
        }
        try {
            return new IntExpression(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.indexOf(36) >= 0) {
                return new FormattedStringExpression(string2);
            }
            return new StringExpression(string);
        }
    }

    public static Expression createPropertyExpression(String string) {
        if (string == null || string.trim().length() == 0) {
            return new NullExpression();
        }
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            return new BeanShellExpression(string2.substring(1, string2.length() - 1));
        }
        return new PropertyMatchExpression(string2);
    }

    public static Expression createSimplePropertyExpression(String string) {
        if (string == null || string.trim().length() == 0) {
            return new NullExpression();
        }
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            return new BeanShellExpression(string2.substring(1, string2.length() - 1));
        }
        return new SinglePropertyExpression(string2);
    }

    public int hashCode() {
        return this.expression == null ? 0 : this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Expression expression = (Expression)object;
        if (this.expression == null && expression.expression != null) {
            return false;
        }
        return this.expression.equals(expression.expression);
    }
}

