/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.svg;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.io.IOUtils;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGImageUtils {
    protected static final SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());

    private SVGImageUtils() {
    }

    public static Dimension getImageSize(InputStream inputStream) throws IOException {
        return SVGImageUtils.getImageSize("", inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(String string, InputStream inputStream) throws IOException {
        Document document;
        Object object;
        try {
            object = factory;
            synchronized (object) {
                document = factory.createDocument(null, inputStream);
            }
            inputStream.close();
        }
        catch (DOMException dOMException) {
            throw new ImageIOException(string, (Throwable)dOMException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImageNotFoundException(string, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ImageIOException(string, (Throwable)iOException);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        object = document.getDocumentElement();
        try {
            int n = (int)((double)Float.parseFloat(object.getAttributeNS(null, "width").replaceFirst("px", "")) + 0.5);
            int n2 = (int)((double)Float.parseFloat(object.getAttributeNS(null, "height").replaceFirst("px", "")) + 0.5);
            return new Dimension(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImageIOException(string, (Throwable)numberFormatException);
        }
    }

    public static List<String> getExternalReferences(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return SVGImageUtils.getExternalReferences(string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getExternalReferences(String string, List<String> list) throws IOException {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        URL uRL = new URL("file", null, new File(string).getCanonicalPath());
        Document document = null;
        try {
            object = factory;
            synchronized (object) {
                document = factory.createDocument(uRL.toString());
            }
        }
        catch (DOMException dOMException) {
            throw (IOException)new IOException().initCause(dOMException);
        }
        object = document.getElementsByTagName("use");
        for (int i = 0; i < object.getLength(); ++i) {
            Element object2 = (Element)object.item(i);
            URL uRL2 = new URL(new URL(object2.getBaseURI()), XLinkSupport.getXLinkHref((Element)object2));
            if (uRL2.getProtocol().equals("file")) {
                String string2 = uRL2.getPath();
                if (list.contains(string2)) continue;
                hashSet.add(string2);
                list.add(string2);
                continue;
            }
            throw new IOException("unsupported protocol '" + uRL2.getProtocol() + "' in xlink:href");
        }
        for (String string3 : hashSet) {
            list.addAll(SVGImageUtils.getExternalReferences(string3, list));
        }
        return list;
    }

    public static byte[] relativizeExternalReferences(String string) throws IOException {
        SAXDocumentFactory sAXDocumentFactory = new SAXDocumentFactory((DOMImplementation)new GenericDOMImplementation(), XMLResourceDescriptor.getXMLParserClassName());
        URL uRL = new URL("file", null, new File(string).getCanonicalPath());
        StringWriter stringWriter = new StringWriter();
        try {
            Document document = sAXDocumentFactory.createDocument(uRL.toString());
            SVGImageUtils.relativizeElement(document.getDocumentElement());
            DOMUtilities.writeDocument((Document)document, (Writer)stringWriter);
        }
        catch (DOMException dOMException) {
            throw (IOException)new IOException().initCause(dOMException);
        }
        stringWriter.flush();
        return stringWriter.toString().getBytes();
    }

    protected static void relativizeElement(Element element) {
        Object object;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            if (object.getNodeType() != 1) continue;
            SVGImageUtils.relativizeElement((Element)object);
        }
        if (element.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
            try {
                URL uRL = new URL(new URL(element.getBaseURI()), XLinkSupport.getXLinkHref((Element)element));
                object = uRL.getRef();
                String string = new File(uRL.getPath()).getName();
                XLinkSupport.setXLinkHref((Element)element, (String)(string + '#' + (String)object));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        element.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
    }
}

