/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.io.IOUtils;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.digest.DigestUtils;

public class TileUtils {
    private TileUtils() {
    }

    public static BufferedImage read(String string) throws ImageIOException {
        return TileUtils.read(new File(string));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage read(File file) throws ImageIOException {
        BufferedImage bufferedImage;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedImage bufferedImage2 = TileUtils.read(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            bufferedImage = bufferedImage2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ImageNotFoundException(file, (Throwable)fileNotFoundException);
                catch (IOException iOException) {
                    throw new ImageIOException(file, (Throwable)iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(InputStream inputStream) throws IOException {
        byte[] byArray = TileUtils.readHeader(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte[] byArray2 = new byte[6];
        byteBuffer.get(byArray2);
        TileUtils.checkSignature(byArray2);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byte[] byArray3 = IOUtils.toByteArray((InputStream)inputStream);
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray3));
            byteBuffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)gZIPInputStream));
            ((InputStream)gZIPInputStream).close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gZIPInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)gZIPInputStream);
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.get(nArray);
        return bufferedImage;
    }

    static byte[] readHeader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[18];
        if (IOUtils.read((InputStream)inputStream, (byte[])byArray) != byArray.length) {
            throw new IOException("header too short!");
        }
        return byArray;
    }

    static void checkSignature(byte[] byArray) throws IOException {
        if (!Arrays.equals(byArray, "VASSAL".getBytes())) {
            throw new IOException("bad signature: got \"" + new String(byArray) + "\", expected \"VASSAL\"");
        }
    }

    public static Dimension size(String string) throws ImageIOException {
        return TileUtils.size(new File(string));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dimension size(File file) throws ImageIOException {
        Dimension dimension;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Dimension dimension2 = TileUtils.size(fileInputStream);
            ((InputStream)fileInputStream).close();
            dimension = dimension2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ImageNotFoundException(file, (Throwable)fileNotFoundException);
                catch (IOException iOException) {
                    throw new ImageIOException(file, (Throwable)iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return dimension;
    }

    public static Dimension size(InputStream inputStream) throws IOException {
        byte[] byArray = TileUtils.readHeader(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte[] byArray2 = new byte[6];
        byteBuffer.get(byArray2);
        TileUtils.checkSignature(byArray2);
        return new Dimension(byteBuffer.getInt(), byteBuffer.getInt());
    }

    public static void write(BufferedImage bufferedImage, String string) throws ImageIOException {
        TileUtils.write(bufferedImage, new File(string));
    }

    public static void write(BufferedImage bufferedImage, File file) throws ImageIOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            TileUtils.write(bufferedImage, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            try {
                throw new ImageIOException(file, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(18);
        byteBuffer.put("VASSAL".getBytes()).putInt(bufferedImage.getWidth()).putInt(bufferedImage.getHeight()).putInt(bufferedImage.getType());
        outputStream.write(byteBuffer.array());
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        byteBuffer = ByteBuffer.allocate(4 * nArray.length);
        byteBuffer.asIntBuffer().put(nArray);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
        gZIPOutputStream.write(byteBuffer.array());
        gZIPOutputStream.finish();
    }

    public static int tileCount(Dimension dimension, Dimension dimension2) {
        return TileUtils.tileCount(dimension.width, dimension.height, dimension2.width, dimension2.height);
    }

    public static int tileCount(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 1;
        while (n / n6 > 0 && n2 / n6 > 0) {
            n5 += TileUtils.tileCountAtScale(n, n2, n3, n4, n6);
            n6 <<= 1;
        }
        return n5;
    }

    public static int tileCountAtScale(Dimension dimension, Dimension dimension2, int n) {
        return TileUtils.tileCountAtScale(dimension.width, dimension.height, dimension2.width, dimension2.height, n);
    }

    public static int tileCountAtScale(int n, int n2, int n3, int n4, int n5) {
        if (n < 1) {
            throw new IllegalArgumentException("iw = " + n + " < 1");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("ih = " + n2 + " < 1");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("tw = " + n3 + " < 1");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("th = " + n4 + " < 1");
        }
        if (n5 < 1) {
            throw new IllegalArgumentException("div = " + n5 + " < 1");
        }
        int n6 = (int)Math.ceil((double)(n / n5) / (double)n3);
        int n7 = (int)Math.ceil((double)(n2 / n5) / (double)n4);
        return n6 * n7;
    }

    public static String tileName(String string, int n, int n2, int n3) {
        String string2 = DigestUtils.shaHex((String)(string + "(" + n + "," + n2 + "@1:" + n3));
        return string2.substring(0, 1) + '/' + string2.substring(0, 2) + '/' + string2;
    }
}

