/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.InputStreamPump;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessCallable
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessCallable.class);
    protected final Process proc;
    protected final InputStreamPump stdoutPump;
    protected final InputStreamPump stderrPump;
    protected final ExecutorService exec;

    public ProcessCallable(Process process, InputStreamPump inputStreamPump, InputStreamPump inputStreamPump2, ExecutorService executorService) {
        if (process == null) {
            throw new IllegalArgumentException("proc == null");
        }
        if (inputStreamPump == null) {
            throw new IllegalArgumentException("stdoutPump == null");
        }
        if (inputStreamPump2 == null) {
            throw new IllegalArgumentException("stderrPump == null");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("exec == null");
        }
        this.proc = process;
        this.stdoutPump = inputStreamPump;
        this.stderrPump = inputStreamPump2;
        this.exec = executorService;
    }

    @Override
    public Integer call() {
        this.stdoutPump.setInputStream(this.proc.getInputStream());
        this.stderrPump.setInputStream(this.proc.getErrorStream());
        Future<?> future = this.exec.submit(this.stdoutPump);
        Future<?> future2 = this.exec.submit(this.stderrPump);
        try {
            int n = this.proc.waitFor();
            this.stopPump(future);
            this.stopPump(future2);
            this.closeStreams();
            return n;
        }
        catch (InterruptedException interruptedException) {
            future.cancel(true);
            future2.cancel(true);
            this.closeStreams();
            this.proc.destroy();
            return -1;
        }
    }

    protected void stopPump(Future<?> future) {
        try {
            future.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            logger.error("", (Throwable)executionException);
        }
        catch (InterruptedException interruptedException) {
            logger.error("", (Throwable)interruptedException);
        }
        catch (TimeoutException timeoutException) {
            logger.error("", (Throwable)timeoutException);
            future.cancel(true);
        }
    }

    protected void closeStreams() {
        IOUtils.closeQuietly((OutputStream)this.proc.getOutputStream());
        IOUtils.closeQuietly((InputStream)this.proc.getErrorStream());
        IOUtils.closeQuietly((InputStream)this.proc.getInputStream());
    }
}

