/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.AbstractProxy;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.Functor;
import VASSAL.tools.menu.MenuMarker;
import VASSAL.tools.menu.ParentProxy;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParent<T extends JComponent>
extends AbstractProxy<T>
implements ParentProxy {
    protected final List<ChildProxy<?>> children = new ArrayList();

    @Override
    public void add(final ChildProxy<?> childProxy) {
        this.children.add(childProxy);
        childProxy.setParent(this);
        if (childProxy instanceof MenuMarker) {
            return;
        }
        this.forEachPeer(new Functor<T>(){

            @Override
            public void apply(T t) {
                ((Container)t).add((Component)childProxy.createPeer());
            }
        });
    }

    protected int proxyIndexToRealIndex(int n) {
        int n2 = -1;
        for (int i = 0; i <= n; ++i) {
            if (this.children.get(i) instanceof MenuMarker) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public void insert(final ChildProxy<?> childProxy, int n) {
        this.children.add(n, childProxy);
        childProxy.setParent(this);
        if (childProxy instanceof MenuMarker) {
            return;
        }
        final int n2 = this.proxyIndexToRealIndex(n);
        this.forEachPeer(new Functor<T>(){

            @Override
            public void apply(T t) {
                ((Container)t).add((Component)childProxy.createPeer(), n2);
            }
        });
    }

    @Override
    public void remove(ChildProxy<?> childProxy) {
        if (this.children.remove(childProxy)) {
            childProxy.setParent(null);
        }
    }

    @Override
    public void remove(int n) {
        ChildProxy<?> childProxy = this.children.remove(n);
        childProxy.setParent(null);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ChildProxy<?>[] getChildren() {
        return this.children.toArray(new ChildProxy[this.children.size()]);
    }

    @Override
    public ChildProxy<?> getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public int getIndex(ChildProxy<?> childProxy) {
        return this.children.indexOf(childProxy);
    }
}

