/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.IOException;
import org.litesoft.p2pchat.IllegalArgument;

public class PeerInfo {
    private String zID = "";
    private String zChatName;
    private String zAddresses;
    private Integer zPort = null;
    private String[] zOldChatNames = null;
    private static final String NO_CHATNAME = "(?)";
    private int failureCount = 0;
    private String zNetworkPw = "";

    public PeerInfo(String string, String string2) {
        this.zChatName = string != null ? string : NO_CHATNAME;
        this.zAddresses = string2;
        IllegalArgument.ifNull("Addresses", this.zAddresses);
    }

    public PeerInfo(String string, String string2, int n) {
        this(string, string2);
        this.zPort = n;
    }

    public PeerInfo(String string, String string2, int n, String string3) {
        this(string, string2, n);
        this.zNetworkPw = string3;
    }

    public void updateWith(PeerInfo peerInfo) {
        if (peerInfo != null) {
            this.setChatName(peerInfo.getChatName());
            this.setAddresses(peerInfo.getAddresses());
            this.setPort(peerInfo.getPort());
            this.setNetworkPw(peerInfo.getNetworkPw());
        }
    }

    public static PeerInfo deFormat(String string) {
        String string2;
        String string3;
        IllegalArgument.ifNull("Formatted", string);
        int n = string.indexOf(58);
        int n2 = string.indexOf(32);
        if (n == -1) {
            return null;
        }
        String string4 = null;
        if (n2 == -1) {
            n2 = string.length();
        } else {
            string4 = string.substring(n2 + 1);
        }
        String string5 = string.substring(0, n);
        String string6 = string.substring(n + 1, n2);
        int n3 = string6.indexOf(47);
        if (n3 == -1) {
            string3 = string6;
            string2 = "";
        } else {
            string3 = string6.substring(0, n3);
            string2 = string6.substring(n3 + 1);
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new PeerInfo(string4, string5, n4, string2);
    }

    public boolean isAddressable() {
        return this.zAddresses != null && this.zPort != null;
    }

    public String getID() {
        return this.zID;
    }

    public void setID(String string) {
        this.zID = string;
        IllegalArgument.ifNull("ID", this.zID);
    }

    public String getChatName() {
        return this.zChatName;
    }

    public String[] getOldChatNames() {
        return this.zOldChatNames;
    }

    public synchronized String getPrevChatName() {
        return this.zOldChatNames == null ? null : this.zOldChatNames[0];
    }

    public synchronized void setChatName(String string) {
        if (string != null && !string.equals(this.zChatName)) {
            if (this.zChatName != null && !this.zChatName.equals(NO_CHATNAME)) {
                if (this.zOldChatNames == null) {
                    this.zOldChatNames = new String[1];
                } else {
                    String[] stringArray = new String[this.zOldChatNames.length + 1];
                    System.arraycopy(this.zOldChatNames, 0, stringArray, 1, this.zOldChatNames.length);
                    this.zOldChatNames = stringArray;
                }
                this.zOldChatNames[0] = this.zChatName;
            }
            this.zChatName = string;
        }
    }

    public String getAddresses() {
        return this.zAddresses;
    }

    public void setAddresses(String string) {
        this.zAddresses = string;
        IllegalArgument.ifNull("Addresses", this.zAddresses);
    }

    public int getPort() {
        return this.zPort == null ? 0 : this.zPort;
    }

    public void setPort(int n) {
        this.zPort = n;
    }

    public String format() {
        return this.zAddresses + ":" + this.zPort + "/" + this.zNetworkPw + " " + this.zChatName;
    }

    public void setNetworkPw(String string) {
        this.zNetworkPw = string;
    }

    public String getNetworkPw() {
        return this.zNetworkPw;
    }

    public int hashCode() {
        int n = 0;
        if (this.zAddresses != null) {
            n += this.zAddresses.hashCode();
        }
        if (this.zPort != null) {
            n += this.zPort.hashCode();
        }
        return n;
    }

    public boolean equals(String string, Integer n) {
        if (this.zAddresses != string) {
            if (this.zAddresses == null) {
                return false;
            }
            if (!this.zAddresses.equals(string)) {
                return false;
            }
        }
        if (this.zPort != n) {
            if (this.zPort == null) {
                return false;
            }
            if (!this.zPort.equals(n)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(PeerInfo peerInfo) {
        return peerInfo == null ? false : this.equals(peerInfo.zAddresses, peerInfo.zPort);
    }

    public boolean equals(Object object) {
        if (object instanceof PeerInfo) {
            return this.equals((PeerInfo)object);
        }
        return false;
    }

    public String toString() {
        String string = this.zID + " " + this.zChatName + " " + this.zAddresses + ":" + (this.zPort != null ? this.zPort.toString() : "?");
        String[] stringArray = this.getOldChatNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + " -> " + stringArray[i];
            }
        }
        return string;
    }

    public int incrementFailureCount() {
        return ++this.failureCount;
    }

    public void setFailureReason(IOException iOException) {
    }
}

