/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.FlowExtTextNode;
import org.apache.batik.extension.svg.MarginInfo;
import org.apache.batik.extension.svg.RegionInfo;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;

public class BatikFlowTextElementBridge
extends SVGTextElementBridge
implements BatikExtConstants {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute PREFORMATTED = GVTAttributedCharacterIterator.TextAttribute.PREFORMATTED;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;

    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "flowText";
    }

    public Bridge getInstance() {
        return new BatikFlowTextElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowExtTextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected void addContextToChild(BridgeContext bridgeContext, Element element) {
        Object object;
        if (this.getNamespaceURI().equals(element.getNamespaceURI()) && (((String)(object = element.getLocalName())).equals("flowPara") || ((String)object).equals("flowRegionBreak") || ((String)object).equals("flowLine") || ((String)object).equals("flowSpan") || ((String)object).equals("a") || ((String)object).equals("tref"))) {
            ((SVGOMElement)element).setSVGContext((SVGContext)new BatikFlowContentBridge(bridgeContext, this, element));
        }
        object = this.getFirstChild(element);
        while (object != null) {
            if (object.getNodeType() == 1) {
                this.addContextToChild(bridgeContext, (Element)object);
            }
            object = this.getNextSibling((Node)object);
        }
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        List list = this.getRegions(bridgeContext, element);
        AttributedString attributedString = this.getFlowDiv(bridgeContext, element);
        if (attributedString == null) {
            return attributedString;
        }
        attributedString.addAttribute(FLOW_REGIONS, list, 0, 1);
        return attributedString;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addGlyphPositionAttributes(attributedString, element, bridgeContext);
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string2;
            if (node.getNodeType() != 1) continue;
            String string3 = node.getNamespaceURI();
            if (!this.getNamespaceURI().equals(string3) && !"http://www.w3.org/2000/svg".equals(string3) || !(string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) continue;
            super.addGlyphPositionAttributes(attributedString, element2, bridgeContext);
            return;
        }
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1) continue;
            String string2 = node.getNamespaceURI();
            if (!this.getNamespaceURI().equals(string2) && !"http://www.w3.org/2000/svg".equals(string2) || !(string = node.getLocalName()).equals("flowPara") && !string.equals("flowRegionBreak") && !string.equals("flowLine") && !string.equals("flowSpan") && !string.equals("a") && !string.equals("tref")) continue;
            this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addPaintAttributes(attributedString, element, textNode, textPaintInfo, bridgeContext);
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string2;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI()) || !(string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) continue;
            super.addPaintAttributes(attributedString, element2, textNode, textPaintInfo, bridgeContext);
            return;
        }
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1) continue;
            String string2 = node.getNamespaceURI();
            if (!this.getNamespaceURI().equals(string2) && !"http://www.w3.org/2000/svg".equals(string2) || !(string = node.getLocalName()).equals("flowPara") && !string.equals("flowRegionBreak") && !string.equals("flowLine") && !string.equals("flowSpan") && !string.equals("a") && !string.equals("tref")) continue;
            Element element2 = (Element)node;
            TextPaintInfo textPaintInfo2 = this.getTextPaintInfo(element2, (GraphicsNode)textNode, textPaintInfo, bridgeContext);
            this.addPaintAttributes(attributedString, element2, textNode, textPaintInfo2, bridgeContext);
        }
    }

    protected AttributedString getFlowDiv(BridgeContext bridgeContext, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI())) continue;
            Element element2 = (Element)node;
            String string = node.getLocalName();
            if (!string.equals("flowDiv")) continue;
            return this.gatherFlowPara(bridgeContext, element2);
        }
        return null;
    }

    protected AttributedString gatherFlowPara(BridgeContext bridgeContext, Element element) {
        int n;
        Object object;
        Object object2;
        TextPaintInfo textPaintInfo = new TextPaintInfo();
        textPaintInfo.visible = true;
        textPaintInfo.fillPaint = Color.black;
        this.elemTPI.put(element, textPaintInfo);
        SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        ArrayList arrayList3 = new ArrayList();
        for (object2 = element.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            if (object2.getNodeType() != 1 || !this.getNamespaceURI().equals(object2.getNamespaceURI())) continue;
            Element element2 = (Element)object2;
            object = element2.getLocalName();
            if (((String)object).equals("flowPara")) {
                this.fillAttributedStringBuffer(bridgeContext, element2, true, null, null, attributedStringBuffer, arrayList3);
                arrayList2.add(element2);
                arrayList.add(new Integer(attributedStringBuffer.length()));
                continue;
            }
            if (!((String)object).equals("flowRegionBreak")) continue;
            this.fillAttributedStringBuffer(bridgeContext, element2, true, null, null, attributedStringBuffer, arrayList3);
            arrayList2.add(element2);
            arrayList.add(new Integer(attributedStringBuffer.length()));
        }
        textPaintInfo.startChar = 0;
        textPaintInfo.endChar = attributedStringBuffer.length() - 1;
        object2 = attributedStringBuffer.toAttributedString();
        int n2 = 0;
        object = arrayList3.iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            if (n == n2) continue;
            ((AttributedString)object2).addAttribute(FLOW_LINE_BREAK, new Object(), n2, n);
            n2 = n;
        }
        n = 0;
        LinkedList<MarginInfo> linkedList = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            Element element3 = (Element)arrayList2.get(i);
            int n3 = (Integer)arrayList.get(i);
            if (n == n3) {
                if (linkedList == null) {
                    linkedList = new LinkedList<MarginInfo>();
                }
                linkedList.add(this.makeMarginInfo(element3));
            } else {
                ((AttributedString)object2).addAttribute(FLOW_PARAGRAPH, this.makeMarginInfo(element3), n, n3);
                if (linkedList != null) {
                    ((AttributedString)object2).addAttribute(FLOW_EMPTY_PARAGRAPH, linkedList, n, n3);
                    linkedList = null;
                }
            }
            n = n3;
        }
        return object2;
    }

    protected List getRegions(BridgeContext bridgeContext, Element element) {
        LinkedList linkedList = new LinkedList();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI()) || !"flowRegion".equals(string = (element2 = (Element)node).getLocalName())) continue;
            float f = 0.0f;
            String string2 = element2.getAttribute("vertical-align");
            if (string2 != null && string2.length() > 0) {
                if ("top".equals(string2)) {
                    f = 0.0f;
                } else if ("middle".equals(string2)) {
                    f = 0.5f;
                } else if ("bottom".equals(string2)) {
                    f = 1.0f;
                }
            }
            this.gatherRegionInfo(bridgeContext, element2, f, linkedList);
        }
        return linkedList;
    }

    protected void gatherRegionInfo(BridgeContext bridgeContext, Element element, float f, List list) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            UnitProcessor.Context context;
            RegionInfo regionInfo;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI())) continue;
            Element element2 = (Element)node;
            String string = node.getLocalName();
            if (!string.equals("rect") || (regionInfo = this.buildRegion(context = UnitProcessor.createContext((BridgeContext)bridgeContext, (Element)element2), element2, f)) == null) continue;
            list.add(regionInfo);
        }
    }

    protected RegionInfo buildRegion(UnitProcessor.Context context, Element element, float f) {
        String string = element.getAttribute("x");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)string, (String)"x", (UnitProcessor.Context)context);
        }
        string = element.getAttribute("y");
        float f3 = 0.0f;
        if (string.length() != 0) {
            f3 = UnitProcessor.svgVerticalCoordinateToUserSpace((String)string, (String)"y", (UnitProcessor.Context)context);
        }
        if ((string = element.getAttribute("width")).length() == 0) {
            throw new BridgeException(this.ctx, element, "attribute.missing", new Object[]{"width", string});
        }
        float f4 = UnitProcessor.svgHorizontalLengthToUserSpace((String)string, (String)"width", (UnitProcessor.Context)context);
        if (f4 == 0.0f) {
            return null;
        }
        string = element.getAttribute("height");
        if (string.length() == 0) {
            throw new BridgeException(this.ctx, element, "attribute.missing", new Object[]{"height", string});
        }
        float f5 = UnitProcessor.svgVerticalLengthToUserSpace((String)string, (String)"height", (UnitProcessor.Context)context);
        if (f5 == 0.0f) {
            return null;
        }
        return new RegionInfo(f2, f3, f4, f5, f);
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, Integer n, Map map, SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer, List list) {
        Object object;
        if (!SVGUtilities.matchUserAgent((Element)element, (UserAgent)bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay((Element)element)) {
            return;
        }
        String string = XMLSupport.getXMLSpace((Element)element);
        boolean bl2 = string.equals("preserve");
        Element element2 = element;
        int n2 = attributedStringBuffer.length();
        if (bl) {
            this.endLimit = 0;
        }
        if (bl2) {
            this.endLimit = attributedStringBuffer.length();
        }
        HashMap hashMap = map == null ? new HashMap() : new HashMap(map);
        map = this.getAttributeMap(bridgeContext, element, null, n, hashMap);
        Object v = hashMap.get(TextAttribute.BIDI_EMBEDDING);
        Integer n3 = n;
        if (v != null) {
            n3 = (Integer)v;
        }
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl3 = bl2 ? false : (attributedStringBuffer.length() == 0 ? true : attributedStringBuffer.getLastChar() == 32);
            switch (node.getNodeType()) {
                case 1: {
                    Object object2;
                    if (!this.getNamespaceURI().equals(node.getNamespaceURI()) && !"http://www.w3.org/2000/svg".equals(node.getNamespaceURI())) continue block4;
                    element2 = (Element)node;
                    object = node.getLocalName();
                    if (((String)object).equals("flowLine")) {
                        int n4 = attributedStringBuffer.length();
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n3, map, attributedStringBuffer, list);
                        list.add(new Integer(attributedStringBuffer.length()));
                        if (attributedStringBuffer.length() == n4) continue block4;
                        map = null;
                        continue block4;
                    }
                    if (((String)object).equals("flowSpan") || ((String)object).equals("altGlyph")) {
                        int n5 = attributedStringBuffer.length();
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n3, map, attributedStringBuffer, list);
                        if (attributedStringBuffer.length() == n5) continue block4;
                        map = null;
                        continue block4;
                    }
                    if (((String)object).equals("a")) {
                        if (bridgeContext.isInteractive()) {
                            NodeEventTarget nodeEventTarget = (NodeEventTarget)element2;
                            object2 = bridgeContext.getUserAgent();
                            SVGAElementBridge.CursorHolder cursorHolder = new SVGAElementBridge.CursorHolder(CursorManager.DEFAULT_CURSOR);
                            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", (EventListener)new SVGAElementBridge.AnchorListener(object2, cursorHolder), false, null);
                            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)new SVGAElementBridge.CursorMouseOverListener(object2, cursorHolder), false, null);
                            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", (EventListener)new SVGAElementBridge.CursorMouseOutListener(object2, cursorHolder), false, null);
                        }
                        int n6 = attributedStringBuffer.length();
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n3, map, attributedStringBuffer, list);
                        if (attributedStringBuffer.length() == n6) continue block4;
                        map = null;
                        continue block4;
                    }
                    if (!((String)object).equals("tref")) continue block4;
                    String string2 = XLinkSupport.getXLinkHref((Element)((Element)node));
                    object2 = bridgeContext.getReferencedElement((Element)node, string2);
                    string = TextUtilities.getElementContent((Element)object2);
                    if ((string = this.normalizeString(string, bl2, bl3)).length() == 0) continue block4;
                    int n7 = attributedStringBuffer.length();
                    HashMap hashMap2 = map == null ? new HashMap() : new HashMap(map);
                    this.getAttributeMap(bridgeContext, element2, null, n, hashMap2);
                    attributedStringBuffer.append(string, hashMap2);
                    int n8 = attributedStringBuffer.length() - 1;
                    TextPaintInfo textPaintInfo = (TextPaintInfo)this.elemTPI.get(element2);
                    textPaintInfo.startChar = n7;
                    textPaintInfo.endChar = n8;
                    map = null;
                    continue block4;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl3);
                    if (string.length() == 0) continue block4;
                    attributedStringBuffer.append(string, hashMap);
                    if (bl2) {
                        this.endLimit = attributedStringBuffer.length();
                    }
                    map = null;
                }
            }
        }
        if (bl) {
            boolean bl4 = false;
            while (this.endLimit < attributedStringBuffer.length() && attributedStringBuffer.getLastChar() == 32) {
                attributedStringBuffer.stripLast();
                bl4 = true;
            }
            if (bl4) {
                for (TextPaintInfo textPaintInfo : this.elemTPI.values()) {
                    if (textPaintInfo.endChar < attributedStringBuffer.length()) continue;
                    textPaintInfo.endChar = attributedStringBuffer.length() - 1;
                    if (textPaintInfo.startChar <= textPaintInfo.endChar) continue;
                    textPaintInfo.startChar = textPaintInfo.endChar;
                }
            }
        }
        int n9 = attributedStringBuffer.length() - 1;
        object = (TextPaintInfo)this.elemTPI.get(element);
        ((TextPaintInfo)object).startChar = n2;
        ((TextPaintInfo)object).endChar = n9;
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n, Map map) {
        Map map2 = super.getAttributeMap(bridgeContext, element, textPath, n, map);
        String string = element.getAttribute("preformatted");
        if (string.length() != 0 && string.equals("true")) {
            map.put(PREFORMATTED, Boolean.TRUE);
        }
        return map2;
    }

    protected void checkMap(Map map) {
        if (map.containsKey(TEXTPATH)) {
            return;
        }
        if (map.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (map.containsKey(LETTER_SPACING)) {
            return;
        }
        if (map.containsKey(WORD_SPACING)) {
            return;
        }
        if (map.containsKey(KERNING)) {
            return;
        }
    }

    public MarginInfo makeMarginInfo(Element element) {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string = element.getAttribute("margin");
        try {
            if (string.length() != 0) {
                f4 = f5 = (f = Float.parseFloat(string));
                f3 = f5;
                f2 = f5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("top-margin");
        try {
            if (string.length() != 0) {
                f2 = f = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("right-margin");
        try {
            if (string.length() != 0) {
                float f6;
                f3 = f6 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("bottom-margin");
        try {
            if (string.length() != 0) {
                float f7;
                f4 = f7 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("left-margin");
        try {
            if (string.length() != 0) {
                float f8;
                f5 = f8 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float f9 = 0.0f;
        string = element.getAttribute("indent");
        try {
            if (string.length() != 0) {
                float f10;
                f9 = f10 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n = 0;
        string = element.getAttribute("justification");
        try {
            if (string.length() != 0) {
                if ("start".equals(string)) {
                    n = 0;
                } else if ("middle".equals(string)) {
                    n = 1;
                } else if ("end".equals(string)) {
                    n = 2;
                } else if ("full".equals(string)) {
                    n = 3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string2 = element.getLocalName();
        boolean bl = string2.equals("flowRegionBreak");
        return new MarginInfo(f2, f3, f4, f5, f9, n, bl);
    }

    protected class BatikFlowContentBridge
    extends SVGTextElementBridge.AbstractTextChildTextContent {
        public BatikFlowContentBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge, Element element) {
            super((SVGTextElementBridge)BatikFlowTextElementBridge.this, bridgeContext, sVGTextElementBridge, element);
        }
    }

    public static class LineBreakInfo {
        int breakIdx;
        float lineAdvAdj;
        boolean relative;

        public LineBreakInfo(int n, float f, boolean bl) {
            this.breakIdx = n;
            this.lineAdvAdj = f;
            this.relative = bl;
        }

        public int getBreakIdx() {
            return this.breakIdx;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public float getLineAdvAdj() {
            return this.lineAdvAdj;
        }
    }
}

