/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.RedactionUtils;

public class PropertiesRequestHandler
extends RequestHandlerBase {
    public static final String REDACT_STRING = RedactionUtils.getRedactString();

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SimpleOrderedMap props = new SimpleOrderedMap();
        String name = req.getParams().get("name");
        if (name != null) {
            String property = this.getSecuredPropertyValue(name);
            props.add(name, (Object)property);
        } else {
            Enumeration<?> enumeration = System.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                name = (String)enumeration.nextElement();
                props.add(name, (Object)this.getSecuredPropertyValue(name));
            }
        }
        rsp.add("system.properties", props);
        rsp.setHttpCaching(false);
    }

    private String getSecuredPropertyValue(String name) {
        if (RedactionUtils.isSystemPropertySensitive(name)) {
            return REDACT_STRING;
        }
        return System.getProperty(name);
    }

    @Override
    public String getDescription() {
        return "Get System Properties";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.ADMIN;
    }
}

