/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.concurrent.Future;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;

class RequestApplyUpdatesOp
implements CoreAdminHandler.CoreAdminOp {
    RequestApplyUpdatesOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.get("name", "");
        CoreAdminOperation.log().info("Applying buffered updates on core: " + cname);
        CoreContainer coreContainer = it.handler.coreContainer;
        try (SolrCore core = coreContainer.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core [" + cname + "] not found");
            }
            UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
            if (updateLog.getState() != UpdateLog.State.BUFFERING) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in buffering state");
            }
            Future<UpdateLog.RecoveryInfo> future = updateLog.applyBufferedUpdates();
            if (future == null) {
                CoreAdminOperation.log().info("No buffered updates available. core=" + cname);
                it.rsp.add("core", cname);
                it.rsp.add("status", "EMPTY_BUFFER");
                return;
            }
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                SolrException.log((Logger)CoreAdminOperation.log(), (String)"Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
            coreContainer.getZkController().publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
            it.rsp.add("core", cname);
            it.rsp.add("status", "BUFFER_APPLIED");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            CoreAdminOperation.log().warn("Recovery was interrupted", (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                throw (SolrException)((Object)e);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not apply buffered updates", (Throwable)e);
        }
        finally {
            if (it.req != null) {
                it.req.close();
            }
        }
    }
}

