/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.DoubleFuncSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;

class StddevSlotAcc
extends DoubleFuncSlotAcc {
    int[] counts;
    double[] sum;

    public StddevSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
        super(values, fcontext, numSlots);
        this.counts = new int[numSlots];
        this.sum = new double[numSlots];
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.counts, 0);
        Arrays.fill(this.sum, 0.0);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        super.resize(resizer);
        this.counts = resizer.resize(this.counts, 0);
        this.result = resizer.resize(this.result, 0.0);
    }

    private double stdDev(double sumSq, double sum, int count) {
        double val = count == 0 ? 0.0 : Math.sqrt(sumSq / (double)count - Math.pow(sum / (double)count, 2.0));
        return val;
    }

    private double stdDev(int slot) {
        return this.stdDev(this.result[slot], this.sum[slot], this.counts[slot]);
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Double.compare(this.stdDev(slotA), this.stdDev(slotB));
    }

    @Override
    public Object getValue(int slot) {
        if (this.fcontext.isShard()) {
            ArrayList<Number> lst = new ArrayList<Number>(3);
            lst.add(this.counts[slot]);
            lst.add(this.result[slot]);
            lst.add(this.sum[slot]);
            return lst;
        }
        return this.stdDev(slot);
    }

    @Override
    public void collect(int doc, int slot) throws IOException {
        double val = this.values.doubleVal(doc);
        if (this.values.exists(doc)) {
            int n = slot;
            this.counts[n] = this.counts[n] + 1;
            int n2 = slot;
            this.result[n2] = this.result[n2] + val * val;
            int n3 = slot;
            this.sum[n3] = this.sum[n3] + val;
        }
    }
}

