/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import java.util.HashMap;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.similarities.PayloadScoringSimilarityWrapper;
import org.apache.solr.util.PayloadDecoder;
import org.apache.solr.util.PayloadUtils;
import org.apache.solr.util.plugin.SolrCoreAware;

public class SchemaSimilarityFactory
extends SimilarityFactory
implements SolrCoreAware {
    private static final String INIT_OPT = "defaultSimFromFieldType";
    private String defaultSimFromFieldType;
    private volatile SolrCore core;
    private volatile Similarity similarity;

    @Override
    public void inform(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(SolrParams args) {
        this.defaultSimFromFieldType = args.get(INIT_OPT, null);
        super.init(args);
    }

    @Override
    public Similarity getSimilarity() {
        if (null == this.core) {
            throw new IllegalStateException("SchemaSimilarityFactory can not be used until SolrCoreAware.inform has been called");
        }
        if (null == this.similarity) {
            BM25Similarity defaultSim = null;
            if (null == this.defaultSimFromFieldType) {
                defaultSim = this.core.getSolrConfig().luceneMatchVersion.onOrAfter(Version.LUCENE_6_0_0) ? new BM25Similarity() : new ClassicSimilarity();
            } else {
                FieldType defSimFT = this.core.getLatestSchema().getFieldTypeByName(this.defaultSimFromFieldType);
                if (null == defSimFT) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SchemaSimilarityFactory configured with defaultSimFromFieldType='" + this.defaultSimFromFieldType + "' but that <fieldType> does not exist");
                }
                defaultSim = defSimFT.getSimilarity();
                if (null == defaultSim) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SchemaSimilarityFactory configured with defaultSimFromFieldType='" + this.defaultSimFromFieldType + "' but that <fieldType> does not define a <similarity>");
                }
            }
            this.similarity = new SchemaSimilarity((Similarity)defaultSim);
        }
        return this.similarity;
    }

    private class SchemaSimilarity
    extends PerFieldSimilarityWrapper {
        private Similarity defaultSimilarity;
        private HashMap<FieldType, PayloadDecoder> decoders;

        public SchemaSimilarity(Similarity defaultSimilarity) {
            this.defaultSimilarity = defaultSimilarity;
        }

        public Similarity get(String name) {
            PayloadDecoder decoder;
            FieldType fieldType = SchemaSimilarityFactory.this.core.getLatestSchema().getFieldTypeNoEx(name);
            if (fieldType == null) {
                return this.defaultSimilarity;
            }
            Similarity similarity = fieldType.getSimilarity();
            Similarity similarity2 = similarity = similarity == null ? this.defaultSimilarity : similarity;
            if (this.decoders == null) {
                this.decoders = new HashMap();
            }
            if (!this.decoders.containsKey(fieldType)) {
                this.decoders.put(fieldType, PayloadUtils.getPayloadDecoder(fieldType));
            }
            if ((decoder = this.decoders.get(fieldType)) != null) {
                similarity = new PayloadScoringSimilarityWrapper(similarity, decoder);
            }
            return similarity;
        }

        public String toString() {
            return "SchemaSimilarity. Default: " + (this.get("") == null ? "null" : this.get("").toString());
        }
    }
}

