/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.search.SolrCacheBase;

public class Metrics
extends SolrCacheBase
implements SolrInfoMBean,
SolrMetricProducer {
    public AtomicLong blockCacheSize = new AtomicLong(0L);
    public AtomicLong blockCacheHit = new AtomicLong(0L);
    public AtomicLong blockCacheMiss = new AtomicLong(0L);
    public AtomicLong blockCacheEviction = new AtomicLong(0L);
    public AtomicLong blockCacheStoreFail = new AtomicLong(0L);
    private AtomicLong blockCacheHit_last = new AtomicLong(0L);
    private AtomicLong blockCacheMiss_last = new AtomicLong(0L);
    private AtomicLong blockCacheEviction_last = new AtomicLong(0L);
    public AtomicLong blockCacheStoreFail_last = new AtomicLong(0L);
    public AtomicLong shardBuffercacheAllocate = new AtomicLong(0L);
    public AtomicLong shardBuffercacheLost = new AtomicLong(0L);
    private long previous = System.nanoTime();

    public NamedList<Number> getStatistics() {
        SimpleOrderedMap stats = new SimpleOrderedMap(21);
        long now = System.nanoTime();
        long delta = Math.max(now - this.previous, 1L);
        double seconds = (double)delta / 1.0E9;
        long hits_total = this.blockCacheHit.get();
        long hits_delta = hits_total - this.blockCacheHit_last.get();
        this.blockCacheHit_last.set(hits_total);
        long miss_total = this.blockCacheMiss.get();
        long miss_delta = miss_total - this.blockCacheMiss_last.get();
        this.blockCacheMiss_last.set(miss_total);
        long evict_total = this.blockCacheEviction.get();
        long evict_delta = evict_total - this.blockCacheEviction_last.get();
        this.blockCacheEviction_last.set(evict_total);
        long storeFail_total = this.blockCacheStoreFail.get();
        long storeFail_delta = storeFail_total - this.blockCacheStoreFail_last.get();
        this.blockCacheStoreFail_last.set(storeFail_total);
        long lookups_delta = hits_delta + miss_delta;
        long lookups_total = hits_total + miss_total;
        stats.add("size", (Object)this.blockCacheSize.get());
        stats.add("lookups", (Object)lookups_total);
        stats.add("hits", (Object)hits_total);
        stats.add("evictions", (Object)evict_total);
        stats.add("storeFails", (Object)storeFail_total);
        stats.add("hitratio_current", (Object)Float.valueOf(Metrics.calcHitRatio(lookups_delta, hits_delta)));
        stats.add("lookups_persec", (Object)Float.valueOf(this.getPerSecond(lookups_delta, seconds)));
        stats.add("hits_persec", (Object)Float.valueOf(this.getPerSecond(hits_delta, seconds)));
        stats.add("evictions_persec", (Object)Float.valueOf(this.getPerSecond(evict_delta, seconds)));
        stats.add("storeFails_persec", (Object)Float.valueOf(this.getPerSecond(storeFail_delta, seconds)));
        stats.add("time_delta", (Object)seconds);
        stats.add("buffercache.allocations", (Object)Float.valueOf(this.getPerSecond(this.shardBuffercacheAllocate.getAndSet(0L), seconds)));
        stats.add("buffercache.lost", (Object)Float.valueOf(this.getPerSecond(this.shardBuffercacheLost.getAndSet(0L), seconds)));
        this.previous = now;
        return stats;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String scope) {
        MetricsMap metrics = new MetricsMap((detailed, map) -> {
            NamedList<Number> nl = this.getStatistics();
            map.putAll(nl.asMap(5));
        });
        manager.registerGauge(registry, metrics, true, this.getName(), this.getCategory().toString(), scope);
    }

    private float getPerSecond(long value, double seconds) {
        return (float)((double)value / seconds);
    }

    @Override
    public String getName() {
        return "HdfsBlockCache";
    }

    @Override
    public String getDescription() {
        return "Provides metrics for the HdfsDirectoryFactory BlockCache.";
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }
}

