/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.Common;

import Common.IntVector;
import SevenZip.Archive.Common.BindPair;
import SevenZip.Archive.Common.CoderStreamsInfo;
import java.util.Vector;

public class BindInfo {
    public Vector<CoderStreamsInfo> Coders = new Vector();
    public Vector<BindPair> BindPairs = new Vector();
    public IntVector InStreams = new IntVector();
    public IntVector OutStreams = new IntVector();

    public void Clear() {
        this.Coders.clear();
        this.BindPairs.clear();
        this.InStreams.clear();
        this.OutStreams.clear();
    }

    public int FindBinderForInStream(int inStream) {
        for (int i = 0; i < this.BindPairs.size(); ++i) {
            if (this.BindPairs.get((int)i).InIndex != inStream) continue;
            return i;
        }
        return -1;
    }

    public int FindBinderForOutStream(int outStream) {
        for (int i = 0; i < this.BindPairs.size(); ++i) {
            if (this.BindPairs.get((int)i).OutIndex != outStream) continue;
            return i;
        }
        return -1;
    }

    public int GetCoderInStreamIndex(int coderIndex) {
        int streamIndex = 0;
        for (int i = 0; i < coderIndex; ++i) {
            streamIndex += this.Coders.get((int)i).NumInStreams;
        }
        return streamIndex;
    }

    public int GetCoderOutStreamIndex(int coderIndex) {
        int streamIndex = 0;
        for (int i = 0; i < coderIndex; ++i) {
            streamIndex += this.Coders.get((int)i).NumOutStreams;
        }
        return streamIndex;
    }

    public int FindInStream(int streamIndex) {
        for (int i = 0; i < this.Coders.size(); ++i) {
            int curSize = this.Coders.get((int)i).NumInStreams;
            if (streamIndex < curSize) {
                return i;
            }
            streamIndex -= curSize;
        }
        return -1;
    }

    public int FindOutStream(int streamIndex) {
        for (int i = 0; i < this.Coders.size(); ++i) {
            int curSize = this.Coders.get((int)i).NumOutStreams;
            if (streamIndex < curSize) {
                return i;
            }
            streamIndex -= curSize;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BindInfo) {
            int i;
            BindInfo arg = (BindInfo)obj;
            if (this.Coders.size() != arg.Coders.size()) {
                return false;
            }
            if (this.BindPairs.size() != arg.BindPairs.size()) {
                return false;
            }
            if (this.InStreams.size() != arg.InStreams.size()) {
                return false;
            }
            if (this.OutStreams.size() != arg.OutStreams.size()) {
                return false;
            }
            for (i = 0; i < this.Coders.size(); ++i) {
                if (this.Coders.get(i).equals(arg.Coders.get(i))) continue;
                return false;
            }
            for (i = 0; i < this.BindPairs.size(); ++i) {
                if (this.BindPairs.get(i).equals(arg.BindPairs.get(i))) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }
}

