/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.IffHeaderChunk;

public class WavRIFFHeader {
    public static final String RIFF_SIGNATURE = "RIFF";
    public static final String WAVE_SIGNATURE = "WAVE";

    public static boolean isValidHeader(RandomAccessFile raf) throws IOException, CannotReadException {
        if (raf.length() < (long)IffHeaderChunk.HEADER_LENGTH) {
            throw new CannotReadException("This is not a WAV File (<12 bytes)");
        }
        ByteBuffer headerBuffer = Utils.readFileDataIntoBufferLE(raf, IffHeaderChunk.HEADER_LENGTH);
        if (Utils.readFourBytesAsChars(headerBuffer).equals(RIFF_SIGNATURE)) {
            headerBuffer.getInt();
            if (Utils.readFourBytesAsChars(headerBuffer).equals(WAVE_SIGNATURE)) {
                return true;
            }
        }
        return false;
    }
}

