/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavRIFFHeader;
import org.jaudiotagger.audio.wav.chunk.WavId3Chunk;
import org.jaudiotagger.audio.wav.chunk.WavListChunk;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");

    public WavTag read(RandomAccessFile raf) throws CannotReadException, IOException {
        WavTag tag = new WavTag(TagOptionSingleton.getInstance().getWavOptions());
        if (WavRIFFHeader.isValidHeader(raf)) {
            while (raf.getFilePointer() < raf.length() && this.readChunk(raf, tag)) {
            }
        } else {
            throw new CannotReadException("Wav RIFF Header not valid");
        }
        this.createDefaultMetadataTagsIfMissing(tag);
        return tag;
    }

    private void createDefaultMetadataTagsIfMissing(WavTag tag) {
        if (!tag.isExistingId3Tag()) {
            tag.setID3Tag(new ID3v23Tag());
        }
        if (!tag.isExistingInfoTag()) {
            tag.setInfoTag(new WavInfoTag());
        }
    }

    protected boolean readChunk(RandomAccessFile raf, WavTag tag) throws IOException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        if (!chunkHeader.readHeader(raf)) {
            return false;
        }
        String id = chunkHeader.getID();
        logger.config("Next Id is:" + id + ":Size:" + chunkHeader.getSize());
        WavChunkType chunkType = WavChunkType.get(id);
        if (chunkType != null) {
            switch (chunkType) {
                case LIST: {
                    WavListChunk chunk = new WavListChunk(Utils.readFileDataIntoBufferLE(raf, (int)chunkHeader.getSize()), chunkHeader, tag);
                    if (((Chunk)chunk).readChunk()) break;
                    return false;
                }
                case ID3: {
                    WavId3Chunk chunk = new WavId3Chunk(Utils.readFileDataIntoBufferLE(raf, (int)chunkHeader.getSize()), chunkHeader, tag);
                    if (((Chunk)chunk).readChunk()) break;
                    return false;
                }
                default: {
                    raf.skipBytes((int)chunkHeader.getSize());
                }
            }
        }
        IffHeaderChunk.ensureOnEqualBoundary(raf, chunkHeader);
        return true;
    }
}

