/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AbstractTagItem;
import org.jaudiotagger.tag.id3.ID3Tags;

public abstract class AbstractTagFrameBody
extends AbstractTagItem {
    private AbstractTagFrame header;
    protected ArrayList<AbstractDataType> objectList = new ArrayList();

    public void createStructure() {
    }

    public final byte getTextEncoding() {
        AbstractDataType o = this.getObject("TextEncoding");
        if (o != null) {
            Long encoding = (Long)o.getValue();
            return encoding.byteValue();
        }
        return 0;
    }

    public final void setTextEncoding(byte textEncoding) {
        this.setObjectValue("TextEncoding", textEncoding);
    }

    protected AbstractTagFrameBody() {
        this.setupObjectList();
    }

    protected AbstractTagFrameBody(AbstractTagFrameBody copyObject) {
        for (int i = 0; i < copyObject.objectList.size(); ++i) {
            AbstractDataType newObject = (AbstractDataType)ID3Tags.copyObject(copyObject.objectList.get(i));
            newObject.setBody(this);
            this.objectList.add(newObject);
        }
    }

    public String getUserFriendlyValue() {
        return this.toString();
    }

    public String getBriefDescription() {
        String str = "";
        for (AbstractDataType object : this.objectList) {
            if (object.toString() == null || object.toString().length() <= 0) continue;
            str = str + object.getIdentifier() + "=\"" + object.toString() + "\"; ";
        }
        return str;
    }

    public final String getLongDescription() {
        String str = "";
        for (AbstractDataType object : this.objectList) {
            if (object.toString() == null || object.toString().length() <= 0) continue;
            str = str + object.getIdentifier() + " = " + object.toString() + "\n";
        }
        return str;
    }

    public final void setObjectValue(String identifier, Object value) {
        ListIterator<AbstractDataType> iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            if (!object.getIdentifier().equals(identifier)) continue;
            object.setValue(value);
        }
    }

    public final Object getObjectValue(String identifier) {
        return this.getObject(identifier).getValue();
    }

    public final AbstractDataType getObject(String identifier) {
        ListIterator<AbstractDataType> iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            if (!object.getIdentifier().equals(identifier)) continue;
            return object;
        }
        return null;
    }

    @Override
    public int getSize() {
        int size = 0;
        ListIterator<AbstractDataType> iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            size += object.getSize();
        }
        return size;
    }

    @Override
    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof AbstractTagFrameBody)) {
            return false;
        }
        ArrayList<AbstractDataType> superset = ((AbstractTagFrameBody)obj).objectList;
        for (AbstractDataType anObjectList : this.objectList) {
            if (anObjectList.getValue() == null || superset.contains(anObjectList)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractTagFrameBody)) {
            return false;
        }
        AbstractTagFrameBody object = (AbstractTagFrameBody)obj;
        boolean check = this.objectList.equals(object.objectList) && super.equals(obj);
        return check;
    }

    public Iterator iterator() {
        return this.objectList.iterator();
    }

    public String toString() {
        return this.getBriefDescription();
    }

    protected abstract void setupObjectList();

    public AbstractTagFrame getHeader() {
        return this.header;
    }

    public void setHeader(AbstractTagFrame header) {
        this.header = header;
    }
}

