/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiPanelConfig;
import beast.app.beauti.ClonePartitionPanel;
import beast.app.beauti.PartitionContext;
import beast.app.draw.InputEditor;
import beast.app.util.Utils;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.MCMC;
import beast.core.util.CompoundDistribution;
import beast.evolution.alignment.Taxon;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.likelihood.GenericTreeLikelihood;
import beast.evolution.sitemodel.SiteModelInterface;
import beast.evolution.tree.TreeInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BeautiPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String ICONPATH = "beast/app/beauti/";
    static int partitionListPreferredWidth = 120;
    private JSplitPane splitPane;
    BeautiDoc doc;
    public BeautiPanelConfig config;
    int panelIndex;
    public int partitionIndex = 0;
    JComponent partitionComponent;
    JList<String> listOfPartitions;
    DefaultListModel<String> listModel;
    JScrollPane scroller;
    Component centralComponent = null;

    public BeautiDoc getDoc() {
        return this.doc;
    }

    public BeautiPanel() {
    }

    public BeautiPanel(int n, BeautiDoc beautiDoc, BeautiPanelConfig beautiPanelConfig) throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.doc = beautiDoc;
        this.panelIndex = n;
        this.setLayout(new BorderLayout());
        this.config = beautiPanelConfig;
        if (this.config.hasPartition() != BeautiPanelConfig.Partition.none && beautiDoc.getPartitions(beautiPanelConfig.hasPartitionsInput.get().toString()).size() > 1) {
            this.splitPane = new JSplitPane(1);
            this.add((Component)this.splitPane, "Center");
        } else {
            this.splitPane = null;
        }
        this.refreshPanel();
        this.addPartitionPanel(this.config.hasPartition(), n);
        this.setOpaque(false);
    }

    void addPartitionPanel(BeautiPanelConfig.Partition partition, int n) {
        Box box = Box.createVerticalBox();
        if (this.splitPane == null || partition == BeautiPanelConfig.Partition.none) {
            return;
        }
        box.add(this.createList());
        box.add(Box.createVerticalGlue());
        box.add(new JLabel(Utils.getIcon(n, this.config)));
        this.splitPane.add((Component)box, "left");
        if (this.listOfPartitions != null) {
            this.listOfPartitions.setSelectedIndex(this.partitionIndex);
        }
    }

    JComponent createList() {
        this.partitionComponent = new JPanel();
        this.partitionComponent.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Partition");
        jLabel.setHorizontalAlignment(0);
        this.partitionComponent.add((Component)jLabel, "North");
        this.listModel = new DefaultListModel();
        this.listOfPartitions = new JList<String>(this.listModel);
        this.listOfPartitions.setName("listOfPartitions");
        this.listOfPartitions.setSelectionMode(2);
        Dimension dimension = new Dimension(partitionListPreferredWidth, 300);
        this.listOfPartitions.setMinimumSize(dimension);
        this.listOfPartitions.addListSelectionListener(this);
        this.updateList();
        JScrollPane jScrollPane = new JScrollPane(this.listOfPartitions);
        this.partitionComponent.add((Component)jScrollPane, "Center");
        return this.partitionComponent;
    }

    public void updateList() {
        if (this.listModel == null) {
            return;
        }
        this.listModel.clear();
        if (this.listModel.size() > 0) {
            return;
        }
        String string = this.config.hasPartitionsInput.get().toString();
        for (BEASTInterface bEASTInterface : this.doc.getPartitions(string)) {
            if (string.equals("SiteModel")) {
                bEASTInterface = (BEASTInterface)((Object)((GenericTreeLikelihood)bEASTInterface).siteModelInput.get());
            } else if (string.equals("ClockModel")) {
                bEASTInterface = ((GenericTreeLikelihood)bEASTInterface).branchRateModelInput.get();
            } else if (string.equals("Tree")) {
                bEASTInterface = (BEASTInterface)((Object)((GenericTreeLikelihood)bEASTInterface).treeInput.get());
            }
            String string2 = bEASTInterface.getID();
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
            if (string2.length() > 1 && string2.charAt(1) == ':') {
                string2 = string2.substring(2);
            }
            this.listModel.addElement(string2);
        }
        if (this.partitionIndex >= 0 && this.listModel.size() > 0) {
            this.listOfPartitions.setSelectedIndex(this.partitionIndex);
        }
    }

    public void refreshPanel() throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.doc.alignments.size() == 0) {
            this.refreshInputPanel();
            return;
        }
        this.doc.scrubAll(true, false);
        if (this.splitPane == null && this.config.hasPartition() != BeautiPanelConfig.Partition.none && this.doc.getPartitions(this.config.hasPartitionsInput.get().toString()).size() > 1) {
            this.splitPane = new JSplitPane(1);
            this.add((Component)this.splitPane, "Center");
            this.addPartitionPanel(this.config.hasPartition(), this.panelIndex);
        }
        if (this.splitPane != null && (this.config.hasPartition() == BeautiPanelConfig.Partition.none || this.doc.getPartitions(this.config.hasPartitionsInput.get().toString()).size() <= 1)) {
            this.remove(this.splitPane);
            this.splitPane = null;
        }
        this.refreshInputPanel();
        if (this.partitionComponent != null && this.config.getType() != null) {
            this.partitionComponent.setVisible(this.doc.getPartitions(this.config.getType()).size() > 1);
        }
    }

    void refreshInputPanel(BEASTInterface bEASTInterface, Input<?> input, boolean bl, InputEditor.ExpandOption expandOption) throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object;
        if (this.centralComponent != null) {
            this.remove(this.centralComponent);
        }
        if (input != null && input.get() != null && input.getType() != null) {
            Serializable serializable;
            object = this.config.buttonStatusInput.get();
            InputEditor inputEditor = this.doc.getInputEditorFactory().createInputEditor(input, bEASTInterface, bl, expandOption, (InputEditor.ButtonStatus)((Object)object), null, this.doc);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            if (this.isToClone()) {
                serializable = new ClonePartitionPanel(this);
                jPanel.add((Component)serializable, "North");
            } else {
                jPanel.add(inputEditor.getComponent(), "Center");
            }
            serializable = new Rectangle(0, 0);
            if (this.scroller != null) {
                JViewport jViewport = this.scroller.getViewport();
                String string = jViewport.toString();
                int n = string.indexOf("lastPaintPosition=java.awt.Point[x=");
                if (n > -1) {
                    n = string.indexOf("y=", n);
                    string = string.substring(n + 2, string.indexOf("]", n));
                    n = Integer.parseInt(string);
                } else {
                    n = 0;
                }
                ((Rectangle)serializable).y = -n;
            }
            this.scroller = new JScrollPane(jPanel);
            this.scroller.getViewport().scrollRectToVisible((Rectangle)serializable);
            this.centralComponent = this.scroller;
        } else {
            this.centralComponent = new JLabel("No input editors.");
        }
        if (this.splitPane != null) {
            object = new JPanel();
            ((Container)object).setLayout(new BorderLayout());
            ((Container)object).add(this.centralComponent, "North");
            this.splitPane.add((Component)object, "right");
        } else {
            this.add(this.centralComponent);
        }
    }

    void refreshInputPanel() throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.doc.currentInputEditors.clear();
        InputEditor.Base.g_nLabelWidth = this.config.labelWidthInput.get();
        BeautiPanelConfig beautiPanelConfig = this.config;
        Input<?> input = this.config.resolveInput(this.doc, this.partitionIndex);
        boolean bl = this.config.addButtons();
        InputEditor.ExpandOption expandOption = this.config.forceExpansion();
        this.refreshInputPanel(beautiPanelConfig, input, bl, expandOption);
    }

    public void cloneFrom(String string, String string2) {
        Object object;
        BEASTInterface bEASTInterface;
        if (string.equals(string2)) {
            return;
        }
        String string3 = this.config.hasPartitionsInput.get().toString();
        List<BEASTInterface> list = this.doc.getPartitions(string3);
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            bEASTInterface = list.get(i);
            if (string3.equals("SiteModel")) {
                bEASTInterface = (BEASTInterface)((Object)((GenericTreeLikelihood)bEASTInterface).siteModelInput.get());
            } else if (string3.equals("ClockModel")) {
                bEASTInterface = ((GenericTreeLikelihood)bEASTInterface).branchRateModelInput.get();
            } else if (string3.equals("Tree")) {
                bEASTInterface = (BEASTInterface)((Object)((GenericTreeLikelihood)bEASTInterface).treeInput.get());
            }
            object = bEASTInterface.getID();
            object = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
            if (((String)object).length() > 1 && ((String)object).charAt(1) == ':') {
                object = ((String)object).substring(2);
            }
            if (((String)object).equals(string)) {
                n = i;
            }
            if (!((String)object).equals(string2)) continue;
            n2 = i;
        }
        if (n2 == -1) {
            throw new RuntimeException("Programmer error: sourceID and targetID should be in list");
        }
        CompoundDistribution compoundDistribution = (CompoundDistribution)this.doc.pluginmap.get("likelihood");
        bEASTInterface = (GenericTreeLikelihood)compoundDistribution.pDistributions.get().get(n);
        object = (GenericTreeLikelihood)compoundDistribution.pDistributions.get().get(n2);
        PartitionContext partitionContext = this.doc.getContextFor(bEASTInterface);
        PartitionContext partitionContext2 = this.doc.getContextFor((BEASTInterface)object);
        this.config._input.setValue(null, this.config);
        if (string3.equals("SiteModel")) {
            SiteModelInterface siteModelInterface = ((GenericTreeLikelihood)bEASTInterface).siteModelInput.get();
            SiteModelInterface.Base base = null;
            try {
                base = (SiteModelInterface.Base)BeautiDoc.deepCopyPlugin((BEASTInterface)((Object)siteModelInterface), (BEASTInterface)object, (MCMC)this.doc.mcmc.get(), partitionContext, partitionContext2, this.doc, null);
            }
            catch (RuntimeException runtimeException) {
                JOptionPane.showMessageDialog(this, "Could not clone " + string + " to " + string2 + " " + runtimeException.getMessage());
                return;
            }
            ((GenericTreeLikelihood)object).siteModelInput.setValue(base, (BEASTInterface)object);
            return;
        }
        if (string3.equals("ClockModel")) {
            BranchRateModel branchRateModel = ((GenericTreeLikelihood)bEASTInterface).branchRateModelInput.get();
            BranchRateModel branchRateModel2 = null;
            try {
                branchRateModel2 = (BranchRateModel)((Object)BeautiDoc.deepCopyPlugin((BEASTInterface)((Object)branchRateModel), (BEASTInterface)object, (MCMC)this.doc.mcmc.get(), partitionContext, partitionContext2, this.doc, null));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Could not clone " + string + " to " + string2 + " " + exception.getMessage());
                return;
            }
            TreeInterface treeInterface = null;
            try {
                for (Input<?> input : ((BEASTInterface)((Object)branchRateModel2)).listInputs()) {
                    if (!input.getName().equals("tree")) continue;
                    treeInterface = (TreeInterface)input.get();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            if (treeInterface != null && treeInterface != ((GenericTreeLikelihood)object).treeInput.get()) {
                JOptionPane.showMessageDialog(null, "Cannot clone clock model with different trees");
                return;
            }
            ((GenericTreeLikelihood)object).branchRateModelInput.setValue(branchRateModel2, (BEASTInterface)object);
            return;
        }
        if (string3.equals("Tree")) {
            TreeInterface treeInterface = null;
            TreeInterface treeInterface2 = ((GenericTreeLikelihood)bEASTInterface).treeInput.get();
            try {
                treeInterface = (TreeInterface)((Object)BeautiDoc.deepCopyPlugin((BEASTInterface)((Object)treeInterface2), (BEASTInterface)object, (MCMC)this.doc.mcmc.get(), partitionContext, partitionContext2, this.doc, null));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Could not clone " + string + " to " + string2 + " " + exception.getMessage());
                return;
            }
            Taxon.assertSameTaxa(treeInterface.getID(), treeInterface.getTaxonset().getTaxaNames(), ((GenericTreeLikelihood)object).dataInput.get().getID(), ((GenericTreeLikelihood)object).dataInput.get().getTaxaNames());
            ((GenericTreeLikelihood)object).treeInput.setValue(treeInterface, (BEASTInterface)object);
            return;
        }
        throw new RuntimeException("Programmer error calling cloneFrom: Should only clone Site/Clock/Tree model");
    }

    private boolean isToClone() {
        return this.listOfPartitions != null && this.listOfPartitions.getSelectedIndices().length > 1;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null) {
            this.config.sync(this.partitionIndex);
            if (this.listOfPartitions != null) {
                this.partitionIndex = Math.max(0, this.listOfPartitions.getSelectedIndex());
            }
        }
        try {
            this.refreshPanel();
            this.centralComponent.repaint();
            this.repaint();
            if (Frame.getFrames().length == 0) {
                return;
            }
            Frame frame = Frame.getFrames()[Frame.getFrames().length - 1];
            frame.setSize(frame.getSize());
            this.centralComponent.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

