/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.InputEditor;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.Runnable;
import beast.core.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Description(value="Defines properties for custom panels in Beauti")
public class BeautiPanelConfig
extends BEASTObject {
    public final Input<String> nameInput = new Input("panelname", "name of the panel, used to label the panel and in the visibility menu", Input.Validate.REQUIRED);
    public final Input<String> tipTextInput = new Input("tiptext", "tiptext shown when hovering over the tab", Input.Validate.REQUIRED);
    public final Input<String> pathInput = new Input("path", "path of the BEASTObject to be shown in this panel, in xpath-like format. For example operator to edit the operator input of the top level run element. distribution/distribution[id='prior'] for prior distributions.distribution/distribution[id='posterior']/traitset all posterior inputs with name traitset", Input.Validate.REQUIRED);
    public final Input<Partition> hasPartitionsInput = new Input<Partition>("hasPartitions", "flag to indicate the panel hasa partition context (and hence a partition list), deafult none.  Possible values: " + Arrays.toString((Object[])Partition.values()), Partition.none, Partition.values());
    public final Input<Boolean> addButtonsInput = new Input<Boolean>("addButtons", "flag to indicate buttons should be added, default true", true);
    public final Input<Boolean> isVisibleInput = new Input<Boolean>("isVisible", "flag to indicate panel is visible on startup, default true", true);
    public final Input<String> iconInput = new Input<String>("icon", "icon shown in the panel relative to /beast/app/beauti, default 0.png", "0.png");
    public final Input<InputEditor.ExpandOption> forceExpansionInput = new Input<InputEditor.ExpandOption>("forceExpansion", "whether to expand the input(s)This can be " + Arrays.toString((Object[])InputEditor.ExpandOption.values()) + " (default 'FALSE')", InputEditor.ExpandOption.FALSE, InputEditor.ExpandOption.values());
    public final Input<String> typeInput = new Input("type", "type used for finding the appropriate beastObject editor. By default, type is determined by the input type of the last component of the path");
    public final Input<Integer> labelWidthInput = new Input<Integer>("labelWidth", "width of labels used to show name of inputs in input editors", 150);
    public final Input<InputEditor.ButtonStatus> buttonStatusInput = new Input<InputEditor.ButtonStatus>("buttonStatus", "whether to show add and delete buttons. This can be " + Arrays.toString((Object[])InputEditor.ButtonStatus.values()) + " (default 'ALL')", InputEditor.ButtonStatus.ALL, InputEditor.ButtonStatus.values());
    String[] pathComponents;
    String[] conditionalAttribute;
    String[] conditionalValue;
    Class<?> type;
    List<BEASTInterface> inputs;
    List<BEASTInterface> startInputs;
    List<BEASTInterface> parentBEASTObjects;
    List<Input<?>> parentInputs = new ArrayList();
    boolean isList;
    FlexibleInput<?> _input;

    @Override
    public void initAndValidate() {
        this.pathComponents = this.pathInput.get().split("/");
        if (this.pathComponents[0].equals("")) {
            this.pathComponents = new String[0];
        }
        this.conditionalAttribute = new String[this.pathComponents.length];
        this.conditionalValue = new String[this.pathComponents.length];
        for (int i = 0; i < this.pathComponents.length; ++i) {
            int n = this.pathComponents[i].indexOf(91);
            if (n < 0) continue;
            String string = this.pathComponents[i].substring(n + 1, this.pathComponents[i].lastIndexOf(93));
            String[] stringArray = string.split("=");
            this.conditionalAttribute[i] = stringArray[0];
            this.conditionalValue[i] = stringArray[1].substring(1, stringArray[1].length() - 1);
            this.pathComponents[i] = this.pathComponents[i].substring(0, n);
        }
        this.inputs = new ArrayList<BEASTInterface>();
        this.startInputs = new ArrayList<BEASTInterface>();
        BEASTObjectPanel.getID(this);
    }

    public String getName() {
        return this.nameInput.get();
    }

    public Partition hasPartition() {
        return this.hasPartitionsInput.get();
    }

    public boolean addButtons() {
        return false;
    }

    public String getIcon() {
        return this.iconInput.get();
    }

    public String getTipText() {
        return this.tipTextInput.get();
    }

    public InputEditor.ExpandOption forceExpansion() {
        return this.forceExpansionInput.get();
    }

    public final Input<?> resolveInput(BeautiDoc beautiDoc, int n) {
        try {
            List<Object> list;
            if (this.hasPartitionsInput.get() == Partition.none) {
                list = new ArrayList<Runnable>();
                list.add(beautiDoc.mcmc.get());
            } else {
                list = beautiDoc.getPartitions(this.hasPartitionsInput.get().toString());
            }
            this.parentBEASTObjects = new ArrayList<BEASTInterface>();
            this.parentInputs = new ArrayList();
            this.parentBEASTObjects.add(beautiDoc);
            this.parentInputs.add(beautiDoc.mcmc);
            this.type = beautiDoc.mcmc.getType();
            this.isList = false;
            for (int i = 0; i < this.pathComponents.length; ++i) {
                Object object = list;
                list = new ArrayList();
                this.parentBEASTObjects = new ArrayList<BEASTInterface>();
                this.parentInputs = new ArrayList();
                Iterator<Object> iterator = object.iterator();
                while (iterator.hasNext()) {
                    BEASTInterface bEASTInterface = (BEASTInterface)iterator.next();
                    Input<?> input = bEASTInterface.getInput(this.pathComponents[i]);
                    this.type = input.getType();
                    if (input.get() instanceof List) {
                        BEASTInterface bEASTInterface2;
                        this.isList = true;
                        List list2 = (List)input.get();
                        if (this.conditionalAttribute[i] == null) {
                            for (Object e : list2) {
                                bEASTInterface2 = (BEASTInterface)e;
                                list.add(bEASTInterface2);
                                this.parentBEASTObjects.add(bEASTInterface);
                                this.parentInputs.add(input);
                            }
                            continue;
                        }
                        int n2 = 0;
                        for (int j = 0; j < list2.size(); ++j) {
                            bEASTInterface2 = (BEASTInterface)list2.get(j);
                            if (!this.matches(bEASTInterface2, this.conditionalAttribute[i], this.conditionalValue[i])) continue;
                            list.add(bEASTInterface2);
                            this.parentBEASTObjects.add(bEASTInterface);
                            this.parentInputs.add(input);
                            ++n2;
                            break;
                        }
                        if (n2 != 0) continue;
                        this.parentInputs.add(input);
                        this.parentBEASTObjects.add(bEASTInterface);
                        continue;
                    }
                    if (input.get() instanceof BEASTInterface) {
                        this.isList = false;
                        if (this.conditionalAttribute[i] == null) {
                            list.add((BEASTInterface)input.get());
                            this.parentBEASTObjects.add(bEASTInterface);
                            this.parentInputs.add(input);
                            continue;
                        }
                        if (!this.matches(bEASTInterface, this.conditionalAttribute[i], this.conditionalValue[i])) continue;
                        list.add(bEASTInterface);
                        this.parentBEASTObjects.add(bEASTInterface);
                        this.parentInputs.add(input);
                        continue;
                    }
                    throw new IllegalArgumentException("input " + this.pathComponents[i] + "  is not a beastObject or list");
                }
            }
            if (this.typeInput.get() != null) {
                this.type = Class.forName(this.typeInput.get());
            }
            if (!this.isList && this.hasPartitionsInput.get() == Partition.none && list.size() > 1) {
                Log.warning.println("WARNING: multiple beastObjects match, but hasPartitions=none");
                this.isList = true;
                this.parentInputs.clear();
            }
            this.inputs.clear();
            this.startInputs.clear();
            for (Object object : list) {
                this.inputs.add((BEASTInterface)object);
                this.startInputs.add((BEASTInterface)object);
            }
            this._input = !this.isList ? new FlexibleInput() : new FlexibleInput(new ArrayList());
            this._input.setRule(Input.Validate.REQUIRED);
            this.syncTo(n);
            if (this.isList) {
                this.checkForDups((List)this._input.get());
            }
            return this._input;
        }
        catch (Exception exception) {
            Log.err.println("Warning: could not find objects in path " + Arrays.toString(this.pathComponents));
            return null;
        }
    }

    private void checkForDups(List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.lastIndexOf(list.get(i)) == i) continue;
            Log.warning.println("We have a dup: " + list.get(i));
            list.remove(i);
            --i;
        }
    }

    private boolean matches(BEASTInterface bEASTInterface, String string, String string2) {
        if (string.equals("id") && bEASTInterface.getID().equals(string2)) {
            return true;
        }
        if (string.equals("type") && bEASTInterface.getClass().getName().equals(string2)) {
            return true;
        }
        return string.equals("type!") && !bEASTInterface.getClass().getName().equals(string2);
    }

    public void sync(int n) {
        block6: {
            if (this.parentInputs.size() <= 0 || this._input.get() == null) break block6;
            Input<?> input = this.parentInputs.get(n);
            if (this.isList) {
                List list = (List)this._input.get();
                List list2 = (List)input.get();
                for (BEASTInterface bEASTInterface : this.startInputs) {
                    list2.remove(bEASTInterface);
                }
                list2.addAll(list);
                for (BEASTInterface bEASTInterface : list) {
                    if (!(bEASTInterface instanceof BEASTInterface)) continue;
                    bEASTInterface.getOutputs().add(this.parentBEASTObjects.get(n));
                }
            } else {
                try {
                    input.setValue(this._input.get(), this.parentBEASTObjects.get(n));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void syncTo(int n) {
        this._input.setType(this.type);
        try {
            if (this.isList) {
                for (BEASTInterface bEASTInterface : this.inputs) {
                    this._input.setValue(bEASTInterface, this);
                }
            } else if (this.inputs.size() > 0) {
                BEASTInterface bEASTInterface = this.inputs.get(n);
                this._input.setValue(bEASTInterface, this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    final Input<?> getInput() {
        return this._input;
    }

    public String getType() {
        if (this.isList) {
            return this.inputs.get(0).getClass().getName();
        }
        if (this._input == null) {
            return null;
        }
        return this._input.get().getClass().getName();
    }

    class FlexibleInput<T>
    extends Input<T> {
        FlexibleInput() {
            super("xx", "");
        }

        public FlexibleInput(T t) {
            super("xx", "", t);
        }

        @Override
        public void setType(Class<?> clazz) {
            this.theClass = clazz;
        }
    }

    public static enum Partition {
        none,
        Partition,
        SiteModel,
        ClockModel,
        Tree;

    }
}

