/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiPanelConfig;
import beast.app.beauti.PriorProvider;
import beast.app.beauti.TaxonSetDialog;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.InputEditor;
import beast.app.draw.ListInputEditor;
import beast.app.draw.SmallButton;
import beast.core.BEASTInterface;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.Logger;
import beast.core.State;
import beast.core.StateNode;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeDistribution;
import beast.evolution.tree.TreeInterface;
import beast.math.distributions.MRCAPrior;
import beast.math.distributions.OneOnX;
import beast.math.distributions.Prior;
import beast.util.AddOnManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class PriorListInputEditor
extends ListInputEditor {
    private static final long serialVersionUID = 1L;
    List<JButton> rangeButtons;
    List<JButton> taxonButtons;
    List<PriorProvider> priorProviders;

    public PriorListInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return List.class;
    }

    @Override
    public Class<?> baseType() {
        return Distribution.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        List list = (List)input.get();
        Collections.sort(list, (object, object2) -> {
            if (object instanceof BEASTInterface && object2 instanceof BEASTInterface) {
                String string = ((BEASTInterface)object).getID();
                String string2 = ((BEASTInterface)object2).getID();
                if (object instanceof TreeDistribution) {
                    if (object2 instanceof TreeDistribution) {
                        TreeInterface treeInterface;
                        TreeInterface treeInterface2 = ((TreeDistribution)object).treeInput.get();
                        if (treeInterface2 == null) {
                            treeInterface2 = ((TreeDistribution)object).treeIntervalsInput.get().treeInput.get();
                        }
                        if ((treeInterface = ((TreeDistribution)object2).treeInput.get()) == null) {
                            treeInterface = ((TreeDistribution)object2).treeIntervalsInput.get().treeInput.get();
                        }
                        return string.compareTo(string2);
                    }
                    return -1;
                }
                if (object instanceof MRCAPrior) {
                    if (object2 instanceof MRCAPrior) {
                        return string.compareTo(string2);
                    }
                    return 1;
                }
                if (object2 instanceof TreeDistribution) {
                    return 1;
                }
                if (object2 instanceof MRCAPrior) {
                    return -1;
                }
                if (object instanceof Prior) {
                    string = ((Prior)object).getParameterName();
                }
                if (object2 instanceof Prior) {
                    string2 = ((Prior)object2).getParameterName();
                }
                return string.compareTo(string2);
            }
            return 0;
        });
        this.rangeButtons = new ArrayList<JButton>();
        this.taxonButtons = new ArrayList<JButton>();
        super.init(input, bEASTInterface, n, expandOption, bl);
        if (bEASTInterface instanceof BeautiPanelConfig) {
            BeautiPanelConfig beautiPanelConfig = (BeautiPanelConfig)bEASTInterface;
            if (beautiPanelConfig.parentBEASTObjects != null && beautiPanelConfig.parentBEASTObjects.size() > 0 && beautiPanelConfig.parentBEASTObjects.get(0).getID().equals("speciescoalescent")) {
                this.m_buttonStatus = InputEditor.ButtonStatus.NONE;
            }
        }
        if (this.m_buttonStatus == InputEditor.ButtonStatus.ALL || this.m_buttonStatus == InputEditor.ButtonStatus.ADD_ONLY) {
            this.addButton = new SmallButton("+ Add Prior", true);
            this.addButton.setName("addItem");
            this.addButton.setToolTipText("Add new prior (like an MRCA-prior) to the list of priors");
            this.addButton.addActionListener(actionEvent -> this.addItem());
            this.buttonBox.add(this.addButton);
            this.buttonBox.add(Box.createHorizontalGlue());
        }
    }

    @Override
    protected InputEditor addPluginItem(Box box, BEASTInterface bEASTInterface) {
        try {
            int n = ((List)this.m_input.get()).indexOf(bEASTInterface);
            InputEditor inputEditor = this.doc.getInputEditorFactory().createInputEditor(this.m_input, n, bEASTInterface, false, InputEditor.ExpandOption.FALSE, InputEditor.ButtonStatus.NONE, null, this.doc);
            box.add((Component)((Object)inputEditor));
            return inputEditor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this;
        }
    }

    String paramToString(RealParameter realParameter) {
        Double d = realParameter.lowerValueInput.get();
        Double d2 = realParameter.upperValueInput.get();
        return "initial = " + realParameter.valuesInput.get() + " [" + (d == null ? "-\u221e" : d + "") + "," + (d2 == null ? "\u221e" : d2 + "") + "]";
    }

    Set<Taxon> getTaxonCandidates(MRCAPrior mRCAPrior) {
        HashSet<Taxon> hashSet = new HashSet<Taxon>();
        Tree tree = mRCAPrior.treeInput.get();
        String[] stringArray = null;
        if (tree.m_taxonset.get() != null) {
            try {
                String[] stringArray2 = tree.m_taxonset.get();
                stringArray2.initAndValidate();
                stringArray = stringArray2.asStringList().toArray(new String[0]);
            }
            catch (Exception exception) {
                stringArray = mRCAPrior.treeInput.get().getTaxaNames();
            }
        } else {
            stringArray = mRCAPrior.treeInput.get().getTaxaNames();
        }
        for (String string : stringArray) {
            hashSet.add(this.doc.getTaxon(string));
        }
        return hashSet;
    }

    @Override
    protected void addItem() {
        super.addItem();
        this.sync();
        this.refreshPanel();
    }

    private void initProviders() {
        this.priorProviders = new ArrayList<PriorProvider>();
        this.priorProviders.add(new MRCAPriorProvider());
        List<String> list = AddOnManager.find(PriorProvider.class, new String[]{"beast.app"});
        for (String string : list) {
            try {
                if (string.startsWith(this.getClass().getName())) continue;
                PriorProvider priorProvider = (PriorProvider)Class.forName(string).newInstance();
                this.priorProviders.add(priorProvider);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
    }

    @Override
    protected List<BEASTInterface> pluginSelector(Input<?> input, BEASTInterface bEASTInterface, List<String> list) {
        List<Object> list2;
        ArrayList<BEASTInterface> arrayList;
        if (this.priorProviders == null) {
            this.initProviders();
        }
        PriorProvider priorProvider = this.priorProviders.get(0);
        if (this.priorProviders.size() > 1) {
            arrayList = new ArrayList<BEASTInterface>();
            list2 = new ArrayList();
            for (PriorProvider priorProvider2 : this.priorProviders) {
                if (!priorProvider2.canProvidePrior(this.doc)) continue;
                arrayList.add((BEASTInterface)((Object)priorProvider2.getDescription()));
                list2.add(priorProvider2);
            }
            String string = (String)JOptionPane.showInputDialog(null, "Which prior do you want to add", "Option", 2, null, arrayList.toArray(), arrayList.get(0));
            if (string == null) {
                return null;
            }
            int n = arrayList.indexOf(string);
            priorProvider = (PriorProvider)list2.get(n);
        }
        arrayList = new ArrayList();
        list2 = priorProvider.createDistribution(this.doc);
        if (list2 == null) {
            return null;
        }
        for (Distribution distribution : list2) {
            arrayList.add(distribution);
        }
        return arrayList;
    }

    class MRCAPriorProvider
    implements PriorProvider {
        MRCAPriorProvider() {
        }

        @Override
        public List<Distribution> createDistribution(BeautiDoc beautiDoc) {
            ArrayList<Distribution> arrayList;
            MRCAPrior mRCAPrior = new MRCAPrior();
            try {
                arrayList = new ArrayList<Distribution>();
                PriorListInputEditor.this.getDoc().scrubAll(true, false);
                State state = (State)beautiDoc.pluginmap.get("state");
                for (StateNode object2 : state.stateNodeInput.get()) {
                    if (!(object2 instanceof Tree)) continue;
                    arrayList.add((Distribution)((Object)((Tree)object2)));
                }
                int n = 0;
                if (arrayList.size() > 1) {
                    Object[] objectArray = new String[arrayList.size()];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = ((Tree)arrayList.get(i)).getID();
                    }
                    n = JOptionPane.showOptionDialog(null, "Select a tree", "MRCA selector", 2, 3, null, objectArray, arrayList.get(0));
                }
                if (n < 0) {
                    return null;
                }
                mRCAPrior.treeInput.setValue(arrayList.get(n), mRCAPrior);
                TaxonSet taxonSet = new TaxonSet();
                TaxonSetDialog taxonSetDialog = new TaxonSetDialog(taxonSet, PriorListInputEditor.this.getTaxonCandidates(mRCAPrior), beautiDoc);
                if (!taxonSetDialog.showDialog() || taxonSetDialog.taxonSet.getID() == null || taxonSetDialog.taxonSet.getID().trim().equals("")) {
                    return null;
                }
                TaxonSet taxonSet2 = taxonSetDialog.taxonSet;
                if (taxonSet2.taxonsetInput.get().size() == 0) {
                    JOptionPane.showMessageDialog(beautiDoc.beauti, "At least one taxon should be included in the taxon set", "Error specifying taxon set", 0);
                    return null;
                }
                int n2 = 1;
                String string = taxonSet2.getID();
                while (beautiDoc.pluginmap.containsKey(taxonSet2.getID()) && beautiDoc.pluginmap.get(taxonSet2.getID()) != taxonSet2) {
                    taxonSet2.setID(string + n2);
                    ++n2;
                }
                BEASTObjectPanel.addPluginToMap(taxonSet2, beautiDoc);
                mRCAPrior.taxonsetInput.setValue(taxonSet2, mRCAPrior);
                mRCAPrior.setID(taxonSet2.getID() + ".prior");
                mRCAPrior.distInput.setValue(new OneOnX(), mRCAPrior);
                mRCAPrior.distInput.setValue(null, mRCAPrior);
                Logger logger = (Logger)beautiDoc.pluginmap.get("tracelog");
                logger.loggersInput.setValue(mRCAPrior, logger);
            }
            catch (Exception exception) {
                // empty catch block
            }
            arrayList = new ArrayList();
            arrayList.add(mRCAPrior);
            g_collapsedIDs.add(mRCAPrior.getID());
            return arrayList;
        }

        @Override
        public String getDescription() {
            return "MRCA prior";
        }
    }

    class MRCAPriorActionListener
    implements ActionListener {
        MRCAPrior m_prior;

        MRCAPriorActionListener(MRCAPrior mRCAPrior) {
            this.m_prior = mRCAPrior;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.m_prior.isMonophyleticInput.setValue(((JCheckBox)actionEvent.getSource()).isSelected(), this.m_prior);
                PriorListInputEditor.this.refreshPanel();
            }
            catch (Exception exception) {
                Log.err.println("PriorListInputEditor " + exception.getMessage());
            }
        }
    }
}

