/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.datatype;

import beast.core.Description;
import beast.evolution.datatype.DataType;

@Description(value="Datatype for integer sequences")
public class IntegerData
extends DataType.Base {
    public IntegerData() {
        this.stateCount = -1;
        this.mapCodeToStateSet = null;
        this.codeLength = -1;
        this.codeMap = null;
    }

    @Override
    public String getTypeDescription() {
        return "integer";
    }

    @Override
    public boolean isAmbiguousState(int n) {
        return n < 0;
    }

    @Override
    public char getChar(int n) {
        if (n < 0) {
            return '?';
        }
        return (char)(48 + n);
    }

    @Override
    public String getCode(int n) {
        if (n < 0) {
            return "?";
        }
        return n + "";
    }
}

