/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.parameter.Parameter;
import java.util.List;

@Description(value="A temporary helper class to solve compound state nodes for operators, but it cannot be used as input, before the framework is modified.")
public class CompoundParameterHelper<T> {
    protected int[] parameterIndex;
    final List<Parameter<T>> parameterList;

    public CompoundParameterHelper(List<Parameter<T>> list) {
        this.parameterList = list;
        if (list == null || list.size() < 1) {
            throw new IllegalArgumentException("There is no parameter inputted into CompoundParameter !");
        }
        int n = 0;
        for (Parameter<T> parameter : list) {
            n += parameter.getDimension();
        }
        this.parameterIndex = new int[n];
        for (int i = 0; i < list.size(); ++i) {
            Parameter<T> parameter;
            parameter = list.get(i);
            for (int j = 0; j < parameter.getDimension(); ++j) {
                this.parameterIndex[i + j] = i;
            }
        }
    }

    public int getDimension() {
        return this.parameterIndex.length;
    }

    public void setValue(int n, T t) {
        Parameter<T> parameter = this.parameterList.get(this.getY(n));
        parameter.setValue(this.getX(n), t);
    }

    public T getValue(int n) {
        return this.parameterList.get(this.getY(n)).getValue(this.getX(n));
    }

    public T getLower(int n) {
        return this.parameterList.get(this.getY(n)).getLower();
    }

    public T getUpper(int n) {
        return this.parameterList.get(this.getY(n)).getUpper();
    }

    protected int getX(int n) {
        int n2 = this.parameterList.get(0).getDimension();
        if (n < n2) {
            return n;
        }
        for (int i = 1; i < this.getY(n); ++i) {
            n2 += this.parameterList.get(i).getDimension();
        }
        return n - n2;
    }

    protected int getY(int n) {
        return this.parameterIndex[n];
    }
}

