/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.StateNode;
import beast.core.parameter.Parameter;
import beast.evolution.speciation.SpeciesTreePrior;
import beast.evolution.speciation.TreeTopFinder;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Description(value="Logs tree annotated with metadata in StarBeast format")
public class SpeciesTreeLogger
extends BEASTObject
implements Loggable {
    public final Input<Tree> treeInput = new Input("tree", "tree to be logged", Input.Validate.REQUIRED);
    public final Input<Function> parameterInput = new Input("popSize", "population size parameter associated with tree nodes", Input.Validate.REQUIRED);
    public final Input<Function> parameterTopInput = new Input("popSizeTop", "population size parameter associated with top of tree branches, only used for non-constant *beast analysis");
    public final Input<SpeciesTreePrior> speciesTreePriorInput = new Input("speciesTreePrior", "species tree prior, used to find which Population Size Function is used. If not specified, assumes 'constant'");
    public final Input<TreeTopFinder> treeTopFinderInput = new Input("treetop", "calculates height of species tree", Input.Validate.REQUIRED);
    public final Input<List<Function>> metadataInput = new Input("metadata", "meta data to be logged with the tree nodes", new ArrayList());
    SpeciesTreePrior.TreePopSizeFunction popSizeFunction;
    String metaDataLabel;
    static final String dmv = "dmv";
    static final String dmt = "dmt";

    @Override
    public void initAndValidate() {
        this.metaDataLabel = "[&dmv=";
        this.popSizeFunction = this.speciesTreePriorInput.get() != null ? this.speciesTreePriorInput.get().popFunctionInput.get() : SpeciesTreePrior.TreePopSizeFunction.constant;
    }

    @Override
    public void init(PrintStream printStream) {
        this.treeInput.get().init(printStream);
    }

    @Override
    public void log(int n, PrintStream printStream) {
        Function function;
        Tree tree = (Tree)this.treeInput.get().getCurrent();
        Function function2 = this.parameterInput.get();
        if (function2 instanceof StateNode) {
            function2 = ((StateNode)function2).getCurrent();
        }
        if ((function = this.parameterTopInput.get()) != null && function instanceof StateNode) {
            function = ((StateNode)function).getCurrent();
        }
        List<Function> list = this.metadataInput.get();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof StateNode)) continue;
            list.set(i, ((StateNode)list.get(i)).getCurrent());
        }
        printStream.print("tree STATE_" + n + " = ");
        tree.getRoot().sort();
        printStream.print(this.toNewick(tree.getRoot(), function2, function, list));
        printStream.print(";");
    }

    String toNewick(Node node, Function function, Function function2, List<Function> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (node.getLeft() != null) {
            stringBuilder.append("(");
            stringBuilder.append(this.toNewick(node.getLeft(), function, function2, list));
            if (node.getRight() != null) {
                stringBuilder.append(',');
                stringBuilder.append(this.toNewick(node.getRight(), function, function2, list));
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append(node.getNr() + Tree.taxaTranslationOffset);
        }
        stringBuilder.append("[&");
        switch (this.popSizeFunction) {
            case constant: {
                double d = function.getArrayValue(node.getNr());
                stringBuilder.append("dmv=").append(d);
                break;
            }
            case linear: 
            case linear_with_constant_root: {
                stringBuilder.append("dmt=");
                double d = node.isRoot() ? this.treeTopFinderInput.get().getHighestTreeHeight() - node.getHeight() : node.getLength();
                stringBuilder.append(d).append(",dmv={");
                double d2 = node.isLeaf() ? function.getArrayValue(node.getNr()) : this.getMetaDataTopValue(node.getLeft(), function2) + this.getMetaDataTopValue(node.getRight(), function2);
                stringBuilder.append(d2);
                double d3 = node.isRoot() && this.popSizeFunction == SpeciesTreePrior.TreePopSizeFunction.linear_with_constant_root ? d2 : this.getMetaDataTopValue(node, function2);
                stringBuilder.append(",").append(d3).append("}");
            }
        }
        if (list.size() > 0) {
            for (Function function3 : list) {
                if (list.indexOf(function3) > 0 || stringBuilder.length() > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(((BEASTObject)((Object)function3)).getID());
                stringBuilder.append('=');
                if (function3 instanceof Parameter) {
                    Parameter parameter = (Parameter)function3;
                    int n = parameter.getMinorDimension1();
                    if (n > 1) {
                        stringBuilder.append('{');
                        for (int i = 0; i < n; ++i) {
                            stringBuilder.append(parameter.getMatrixValue(node.getNr(), i));
                            if (i >= n - 1) continue;
                            stringBuilder.append(',');
                        }
                        stringBuilder.append('}');
                        continue;
                    }
                    stringBuilder.append(function3.getArrayValue(node.getNr()));
                    continue;
                }
                stringBuilder.append(function3.getArrayValue(node.getNr()));
            }
        }
        stringBuilder.append(']');
        if (!node.isRoot()) {
            stringBuilder.append(":").append(node.getLength());
        }
        return stringBuilder.toString();
    }

    double getMetaDataTopValue(Node node, Function function) {
        int n = node.getNr();
        if (n >= function.getDimension()) {
            n = node.getTree().getRoot().getNr();
        }
        return function.getArrayValue(n);
    }

    @Override
    public void close(PrintStream printStream) {
        this.treeInput.get().close(printStream);
    }
}

