/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.util.Log;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import java.io.PrintStream;

@Description(value="Logger to report statistics of a tree")
public class TreeStatLogger
extends CalculationNode
implements Loggable,
Function {
    public final Input<Tree> treeInput = new Input("tree", "tree to report height for.", Input.Validate.REQUIRED);
    @Deprecated
    public final Input<Boolean> logHeigthInput = new Input<Boolean>("logHeigth", "If true, tree height will be logged (unless logHeight input = false).", true);
    public final Input<Boolean> logHeightInput = new Input<Boolean>("logHeight", "If true, tree height will be logged.", true);
    public final Input<Boolean> logLengthInput = new Input<Boolean>("logLength", "If true, tree length will be logged.", true);

    @Override
    public void initAndValidate() {
        if (!(this.logHeigthInput.get().booleanValue() && this.logHeightInput.get().booleanValue() || this.logLengthInput.get().booleanValue())) {
            Log.warning.println("TreeStatLogger " + this.getID() + "logs nothing. Set logHeight=true or logLength=true to log at least something");
        }
    }

    @Override
    public void init(PrintStream printStream) {
        Tree tree = this.treeInput.get();
        if (this.logHeigthInput.get().booleanValue() && this.logHeightInput.get().booleanValue()) {
            printStream.print(tree.getID() + ".height\t");
        }
        if (this.logLengthInput.get().booleanValue()) {
            printStream.print(tree.getID() + ".treeLength\t");
        }
    }

    @Override
    public void log(int n, PrintStream printStream) {
        Tree tree = this.treeInput.get();
        if (this.logHeigthInput.get().booleanValue() && this.logHeightInput.get().booleanValue()) {
            printStream.print(tree.getRoot().getHeight() + "\t");
        }
        if (this.logLengthInput.get().booleanValue()) {
            printStream.print(this.getLength(tree) + "\t");
        }
    }

    private double getLength(Tree tree) {
        double d = 0.0;
        for (Node node : tree.getNodesAsArray()) {
            if (node.isRoot()) continue;
            d += node.getLength();
        }
        return d;
    }

    @Override
    public void close(PrintStream printStream) {
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getArrayValue() {
        return this.treeInput.get().getRoot().getHeight();
    }

    @Override
    public double getArrayValue(int n) {
        if (n == 0) {
            return this.treeInput.get().getRoot().getHeight();
        }
        return this.getLength(this.treeInput.get());
    }
}

