/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.Distribution;
import org.apache.commons.math.special.Gamma;

@Description(value="Dirichlet distribution.  p(x_1,...,x_n;alpha_1,...,alpha_n) = 1/B(alpha) prod_{i=1}^K x_i^{alpha_i - 1} where B() is the beta function B(alpha) = prod_{i=1}^K Gamma(alpha_i)/ Gamma(sum_{i=1}^K alpha_i}. ")
public class Dirichlet
extends ParametricDistribution {
    public final Input<RealParameter> alphaInput = new Input("alpha", "coefficients of the Dirichlet distribution", Input.Validate.REQUIRED);

    @Override
    public void initAndValidate() {
    }

    @Override
    public Distribution getDistribution() {
        return null;
    }

    @Override
    public double calcLogP(Function function) {
        Double[] doubleArray = (Double[])this.alphaInput.get().getValues();
        if (this.alphaInput.get().getDimension() != function.getDimension()) {
            throw new IllegalArgumentException("Dimensions of alpha and x should be the same, but dim(alpha)=" + this.alphaInput.get().getDimension() + " and dim(x)=" + function.getDimension());
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < function.getDimension(); ++i) {
            double d3 = function.getArrayValue(i);
            d += (doubleArray[i] - 1.0) * Math.log(d3);
            d -= Gamma.logGamma(doubleArray[i]);
            d2 += doubleArray[i].doubleValue();
        }
        return d += Gamma.logGamma(d2);
    }

    class DirichletImpl
    implements ContinuousDistribution {
        Double[] m_fAlpha;

        DirichletImpl() {
        }

        void setAlpha(Double[] doubleArray) {
            this.m_fAlpha = doubleArray;
        }

        @Override
        public double cumulativeProbability(double d) throws MathException {
            throw new MathException("Not implemented yet", new Object[0]);
        }

        @Override
        public double cumulativeProbability(double d, double d2) throws MathException {
            throw new MathException("Not implemented yet", new Object[0]);
        }

        @Override
        public double inverseCumulativeProbability(double d) throws MathException {
            throw new MathException("Not implemented yet", new Object[0]);
        }

        @Override
        public double density(double d) {
            return Double.NaN;
        }

        @Override
        public double logDensity(double d) {
            return Double.NaN;
        }
    }
}

