/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.State;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.math.distributions.ParametricDistribution;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

@Description(value="Prior over set of taxa, useful for defining monophyletic constraints and distributions over MRCA times or (sets of) tips of trees")
public class MRCAPrior
extends Distribution {
    public final Input<Tree> treeInput = new Input("tree", "the tree containing the taxon set", Input.Validate.REQUIRED);
    public final Input<TaxonSet> taxonsetInput = new Input("taxonset", "set of taxa for which prior information is available");
    public final Input<Boolean> isMonophyleticInput = new Input<Boolean>("monophyletic", "whether the taxon set is monophyletic (forms a clade without other taxa) or nor. Default is false.", false);
    public final Input<ParametricDistribution> distInput = new Input("distr", "distribution used to calculate prior over MRCA time, e.g. normal, beta, gamma. If not specified, monophyletic must be true");
    public final Input<Boolean> onlyUseTipsInput = new Input<Boolean>("tipsonly", "flag to indicate tip dates are to be used instead of the MRCA node. If set to true, the prior is applied to the height of all tips in the taxonset and the monophyletic flag is ignored. Default is false.", false);
    public final Input<Boolean> useOriginateInput = new Input<Boolean>("useOriginate", "Use parent of clade instead of clade. Cannot be used with tipsonly, or on the root.", false);
    ParametricDistribution dist;
    Tree tree;
    int nrOfTaxa = -1;
    Set<String> isInTaxaSet = new LinkedHashSet<String>();
    int[] taxonIndex;
    double MRCATime = -1.0;
    double storedMRCATime = -1.0;
    boolean isMonophyletic = false;
    boolean onlyUseTips = false;
    boolean useRoot = false;
    boolean useOriginate = false;
    boolean initialised = false;
    boolean[] nodesTraversed;
    int nseen;

    @Override
    public void initAndValidate() {
        this.dist = this.distInput.get();
        this.tree = this.treeInput.get();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.tree.getTaxaNames()) {
            arrayList.add(string);
        }
        Object object = null;
        if (this.taxonsetInput.get() != null) {
            object = this.taxonsetInput.get().asStringList();
            this.nrOfTaxa = object.size();
        } else {
            this.nrOfTaxa = arrayList.size();
        }
        this.onlyUseTips = this.onlyUseTipsInput.get();
        this.useOriginate = this.useOriginateInput.get();
        if (this.nrOfTaxa == 1 && !this.useOriginate && !this.onlyUseTips) {
            this.onlyUseTips = true;
        }
        if (!this.onlyUseTips && !this.useOriginate && this.nrOfTaxa < 2) {
            throw new IllegalArgumentException("At least two taxa are required in a taxon set");
        }
        if (!this.onlyUseTips && this.taxonsetInput.get() == null) {
            throw new IllegalArgumentException("Taxonset must be specified OR tipsonly be set to true");
        }
        if (this.useOriginate && this.onlyUseTips) {
            throw new IllegalArgumentException("'useOriginate' and 'tipsOnly' cannot be both true");
        }
        boolean bl = this.useRoot = this.nrOfTaxa == this.tree.getLeafNodeCount();
        if (this.useOriginate && this.useRoot) {
            throw new IllegalArgumentException("Cannot use originate of root. You can set useOriginate to false to fix this");
        }
        this.initialised = false;
    }

    protected Node getCommonAncestor(Node node, Node node2) {
        if (!this.nodesTraversed[node.getNr()]) {
            this.nodesTraversed[node.getNr()] = true;
            ++this.nseen;
        }
        if (!this.nodesTraversed[node2.getNr()]) {
            this.nodesTraversed[node2.getNr()] = true;
            ++this.nseen;
        }
        while (node != node2) {
            Node node3;
            double d;
            double d2 = node.getHeight();
            if (d2 < (d = node2.getHeight())) {
                if (this.nodesTraversed[(node = node.getParent()).getNr()]) continue;
                this.nodesTraversed[node.getNr()] = true;
                ++this.nseen;
                continue;
            }
            if (d < d2) {
                if (this.nodesTraversed[(node2 = node2.getParent()).getNr()]) continue;
                this.nodesTraversed[node2.getNr()] = true;
                ++this.nseen;
                continue;
            }
            double d3 = node.getLength();
            double d4 = node2.getLength();
            if (d3 > 0.0) {
                node3 = node2;
            } else if (d4 > 0.0) {
                node3 = node;
            } else {
                for (node3 = node; node3 != null && node3 != node2; node3 = node3.getParent()) {
                }
                node3 = node3 == node2 ? node : node2;
            }
            if (this.nodesTraversed[(node3 = node3 == node ? (node = node3.getParent()) : (node2 = node3.getParent())).getNr()]) continue;
            this.nodesTraversed[node3.getNr()] = true;
            ++this.nseen;
        }
        return node;
    }

    public Node getCommonAncestor() {
        if (!this.initialised) {
            this.initialise();
        }
        this.nodesTraversed = new boolean[this.tree.getNodeCount()];
        Node node = this.getCommonAncestorInternal();
        assert (!this.useRoot || node.isRoot());
        return node;
    }

    private Node getCommonAncestorInternal() {
        Node node = this.tree.getNode(this.taxonIndex[0]);
        for (int i = 1; i < this.taxonIndex.length; ++i) {
            node = this.getCommonAncestor(node, this.tree.getNode(this.taxonIndex[i]));
        }
        return node;
    }

    @Override
    public double calculateLogP() {
        Node node;
        if (!this.initialised) {
            this.initialise();
        }
        this.logP = 0.0;
        if (this.onlyUseTips) {
            if (this.dist == null) {
                return this.logP;
            }
            for (int n : this.taxonIndex) {
                this.MRCATime = this.tree.getNode(n).getDate();
                this.logP += this.dist.logDensity(this.MRCATime);
            }
            return this.logP;
        }
        if (this.useRoot) {
            if (this.dist != null) {
                this.MRCATime = this.tree.getRoot().getDate();
                this.logP += this.dist.logDensity(this.MRCATime);
            }
            return this.logP;
        }
        if (this.taxonIndex.length == 1) {
            this.isMonophyletic = true;
            node = this.tree.getNode(this.taxonIndex[0]);
        } else {
            this.nseen = 0;
            node = this.getCommonAncestor();
            boolean bl = this.isMonophyletic = this.nseen == 2 * this.taxonIndex.length - 1;
        }
        this.MRCATime = this.useOriginate ? (!node.isRoot() ? node.getParent().getDate() : node.getDate()) : node.getDate();
        if (this.isMonophyleticInput.get().booleanValue() && !this.isMonophyletic) {
            this.logP = Double.NEGATIVE_INFINITY;
            return Double.NEGATIVE_INFINITY;
        }
        if (this.dist != null) {
            this.logP = this.dist.logDensity(this.MRCATime);
        }
        return this.logP;
    }

    protected void initialise() {
        List<String> list = null;
        if (this.taxonsetInput.get() != null) {
            list = this.taxonsetInput.get().asStringList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.tree.getTaxaNames()) {
            arrayList.add(string);
        }
        this.taxonIndex = new int[this.nrOfTaxa];
        if (list != null) {
            this.isInTaxaSet.clear();
            int n = 0;
            for (String string : list) {
                int n2 = arrayList.indexOf(string);
                if (n2 < 0) {
                    throw new RuntimeException("Cannot find taxon " + string + " in data");
                }
                if (this.isInTaxaSet.contains(string)) {
                    throw new RuntimeException("Taxon " + string + " is defined multiple times, while they should be unique");
                }
                this.isInTaxaSet.add(string);
                this.taxonIndex[n++] = n2;
            }
        } else {
            for (int i = 0; i < this.nrOfTaxa; ++i) {
                this.taxonIndex[i] = i;
            }
        }
        this.initialised = true;
    }

    int calcMRCAtime(Node node, int[] nArray) {
        if (node.isLeaf()) {
            nArray[0] = nArray[0] + 1;
            if (this.isInTaxaSet.contains(node.getID())) {
                return 1;
            }
            return 0;
        }
        int n = this.calcMRCAtime(node.getLeft(), nArray);
        int n2 = nArray[0];
        nArray[0] = 0;
        if (node.getRight() != null) {
            int n3 = nArray[0];
            nArray[0] = n2 + n3;
            if ((n += this.calcMRCAtime(node.getRight(), nArray)) == this.nrOfTaxa) {
                Node node2;
                if (this.nrOfTaxa == 1 && this.useOriginate) {
                    this.MRCATime = node.getDate();
                    this.isMonophyletic = true;
                    return n + 1;
                }
                this.MRCATime = this.useOriginate ? ((node2 = node.getParent()) != null ? node2.getDate() : node.getDate()) : node.getDate();
                this.isMonophyletic = nArray[0] == this.nrOfTaxa;
                return n + 1;
            }
        }
        return n;
    }

    @Override
    public void store() {
        this.storedMRCATime = this.MRCATime;
        super.store();
    }

    @Override
    public void restore() {
        this.MRCATime = this.storedMRCATime;
        super.restore();
    }

    @Override
    protected boolean requiresRecalculation() {
        return super.requiresRecalculation();
    }

    @Override
    public void init(PrintStream printStream) {
        if (!this.initialised) {
            this.initialise();
        }
        if (this.onlyUseTips) {
            if (this.dist != null) {
                printStream.print("logP(mrca(" + this.getID() + "))\t");
            }
            for (int n : this.taxonIndex) {
                printStream.print("height(" + this.tree.getTaxaNames()[n] + ")\t");
            }
        } else {
            if (!this.isMonophyleticInput.get().booleanValue()) {
                printStream.print("monophyletic(" + this.taxonsetInput.get().getID() + ")\t");
            }
            if (this.dist != null) {
                printStream.print("logP(mrca(" + this.taxonsetInput.get().getID() + "))\t");
            }
            printStream.print("mrcatime(" + this.taxonsetInput.get().getID() + (this.useOriginate ? ".originate" : "") + ")\t");
        }
    }

    @Override
    public void log(int n, PrintStream printStream) {
        if (this.onlyUseTips) {
            if (this.dist != null) {
                printStream.print(this.getCurrentLogP() + "\t");
            }
            for (int n2 : this.taxonIndex) {
                printStream.print(this.tree.getNode(n2).getDate() + "\t");
            }
        } else {
            if (!this.isMonophyleticInput.get().booleanValue()) {
                printStream.print((this.isMonophyletic ? 1 : 0) + "\t");
            }
            if (this.dist != null) {
                printStream.print(this.getCurrentLogP() + "\t");
            } else {
                this.calcMRCAtime(this.tree.getRoot(), new int[1]);
            }
            printStream.print(this.MRCATime + "\t");
        }
    }

    @Override
    public void close(PrintStream printStream) {
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getArrayValue() {
        if (Double.isNaN(this.logP)) {
            try {
                this.calculateLogP();
            }
            catch (Exception exception) {
                this.logP = Double.NaN;
            }
        }
        return this.logP;
    }

    @Override
    public double getArrayValue(int n) {
        if (Double.isNaN(this.logP)) {
            try {
                this.calculateLogP();
            }
            catch (Exception exception) {
                this.logP = Double.NaN;
            }
        }
        switch (n) {
            case 0: {
                return this.logP;
            }
            case 1: {
                return this.MRCATime;
            }
        }
        return 0.0;
    }

    @Override
    public void sample(State state, Random random) {
    }

    @Override
    public List<String> getArguments() {
        return null;
    }

    @Override
    public List<String> getConditions() {
        return null;
    }
}

