/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.distribution.NormalDistributionImpl;

@Description(value="Normal distribution.  f(x) = frac{1}{\\sqrt{2\\pi\\sigma^2}} e^{ -\\frac{(x-\\mu)^2}{2\\sigma^2} } If the input x is a multidimensional parameter, each of the dimensions is considered as a separate independent component.")
public class Normal
extends ParametricDistribution {
    public final Input<RealParameter> meanInput = new Input("mean", "mean of the normal distribution, defaults to 0");
    public final Input<RealParameter> sigmaInput = new Input("sigma", "standard deviation of the normal distribution, defaults to 1");
    public final Input<RealParameter> tauInput = new Input("tau", "precission of the normal distribution, defaults to 1", Input.Validate.XOR, this.sigmaInput);
    static NormalDistribution dist = new NormalDistributionImpl(0.0, 1.0);

    @Override
    public void initAndValidate() {
        this.refresh();
    }

    void refresh() {
        double d = this.meanInput.get() == null ? 0.0 : this.meanInput.get().getValue();
        double d2 = this.sigmaInput.get() == null ? (this.tauInput.get() == null ? 1.0 : Math.sqrt(1.0 / this.tauInput.get().getValue())) : this.sigmaInput.get().getValue();
        dist.setMean(d);
        dist.setStandardDeviation(d2);
    }

    @Override
    public ContinuousDistribution getDistribution() {
        this.refresh();
        return dist;
    }

    @Override
    public double getMean() {
        if (this.meanInput.get() == null) {
            return (Double)this.offsetInput.get();
        }
        return (Double)this.offsetInput.get() + this.meanInput.get().getValue();
    }
}

