/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AbstractFrame;
import jam.html.SimpleLinkListener;
import jam.util.IconUtils;
import jam.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutBox
extends AbstractFrame {
    public AboutBox(String title, String message, Icon icon) {
        if (icon != null) {
            this.setIconImage(IconUtils.getBufferedImageFromIcon(icon));
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                AboutBox.this.close();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27 || event.getKeyCode() == 10) {
                    AboutBox.this.close();
                }
            }
        });
        JPanel contentsPanel = new JPanel(new GridBagLayout());
        contentsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentsPanel.setBackground(Color.white);
        JLabel titleLabel = new JLabel(title, 0);
        Font font = titleLabel.getFont();
        titleLabel.setFont(font.deriveFont(32.0f).deriveFont(0));
        titleLabel.setIcon(icon);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 5, 5);
        contentsPanel.add((Component)titleLabel, c);
        font = font.deriveFont(11.0f);
        if (message.startsWith("<html>")) {
            JEditorPane editorPane = new JEditorPane("text/html", message);
            editorPane.setOpaque(false);
            editorPane.setFont(font);
            editorPane.setEditable(false);
            editorPane.addHyperlinkListener(new SimpleLinkListener());
            contentsPanel.add((Component)editorPane, c);
        } else {
            StringTokenizer tokens = new StringTokenizer(message, "\n");
            while (tokens.hasMoreElements()) {
                String text = tokens.nextToken();
                JLabel messageLabel = new JLabel(text, 0);
                messageLabel.setFont(font);
                contentsPanel.add((Component)messageLabel, c);
            }
        }
        this.getSaveAction().setEnabled(false);
        this.getSaveAsAction().setEnabled(false);
        this.getPrintAction().setEnabled(false);
        this.getPageSetupAction().setEnabled(false);
        this.getCutAction().setEnabled(false);
        this.getCopyAction().setEnabled(false);
        this.getPasteAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getSelectAllAction().setEnabled(false);
        this.getFindAction().setEnabled(false);
        this.getZoomWindowAction().setEnabled(false);
        this.getMinimizeWindowAction().setEnabled(true);
        this.getCloseWindowAction().setEnabled(true);
        this.getContentPane().add(contentsPanel);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        Utils.centerComponent(this, null);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void initializeComponents() {
    }

    @Override
    public boolean requestClose() {
        return false;
    }

    @Override
    public JComponent getExportableComponent() {
        return null;
    }
}

