/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AbstractFrame;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public abstract class DocumentFrame
extends AbstractFrame {
    private File documentFile = null;
    private AbstractAction saveAction = new AbstractAction("Save"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            DocumentFrame.this.doSave();
        }
    };
    private AbstractAction saveAsAction = new AbstractAction("Save As..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            DocumentFrame.this.doSaveAs();
        }
    };

    @Override
    protected abstract void initializeComponents();

    protected abstract boolean readFromFile(File var1) throws IOException;

    protected abstract boolean writeToFile(File var1) throws IOException;

    public final boolean hasFile() {
        return this.documentFile != null;
    }

    public final File getFile() {
        return this.documentFile;
    }

    public final void clearFile() {
        this.documentFile = null;
    }

    @Override
    public boolean requestClose() {
        if (this.isDirty()) {
            int option = JOptionPane.showConfirmDialog(this, "Do you wish to save?", "Unsaved changes", 1, 2);
            if (option == 0) {
                return !this.doSave();
            }
            return option != 2 && option != -1;
        }
        return true;
    }

    public boolean openFile(File file) {
        try {
            if (this.readFromFile(file)) {
                this.documentFile = file;
                this.clearDirty();
                this.setFrameTitle();
                return true;
            }
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, "Unable to open file: File not found", "Unable to open file", 0);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to read file: " + ioe, "Unable to read file", 0);
        }
        return false;
    }

    public boolean doSave() {
        if (!this.hasFile()) {
            return this.doSaveAs();
        }
        try {
            if (this.writeToFile(this.documentFile)) {
                this.clearDirty();
                return true;
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to save file: " + ioe, "Unable to save file", 0);
        }
        return false;
    }

    public boolean doSaveAs() {
        FileDialog dialog = new FileDialog((Frame)this, "Save Document As...", 1);
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return false;
        }
        File file = new File(dialog.getDirectory(), dialog.getFile());
        try {
            if (this.writeToFile(file)) {
                this.clearDirty();
                this.documentFile = file;
                this.setFrameTitle();
                return true;
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to save file: " + ioe, "Unable to save file", 0);
        }
        return false;
    }

    protected final void setFrameTitle() {
        String title = this.getTitle();
        if (this.documentFile != null) {
            this.setTitle(String.valueOf(title) + " - " + this.documentFile.getName());
            this.getRootPane().putClientProperty("Window.documentFile", this.documentFile);
        }
    }

    @Override
    public Action getSaveAction() {
        return this.saveAction;
    }

    @Override
    public Action getSaveAsAction() {
        return this.saveAsAction;
    }
}

