/*
 * Decompiled with CFR 0.152.
 */
package jam.table;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class HeaderRenderer
extends DefaultTableCellRenderer {
    public HeaderRenderer(int alignment, Insets insets) {
        this.setHorizontalAlignment(alignment);
        this.setOpaque(true);
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        this.setBorder(new CompoundBorder(border, new EmptyBorder(insets)));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setEnabled(header.isEnabled());
            this.setComponentOrientation(header.getComponentOrientation());
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        } else {
            this.setEnabled(true);
            this.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
        }
        this.setValue(value);
        return this;
    }
}

