/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.ComposableFunction;

public abstract class BinaryFunction
implements BivariateRealFunction {
    public static final BinaryFunction ADD = new BinaryFunction(){

        @Override
        public double value(double d, double d2) {
            return d + d2;
        }
    };
    public static final BinaryFunction SUBTRACT = new BinaryFunction(){

        @Override
        public double value(double d, double d2) {
            return d - d2;
        }
    };
    public static final BinaryFunction MULTIPLY = new BinaryFunction(){

        @Override
        public double value(double d, double d2) {
            return d * d2;
        }
    };
    public static final BinaryFunction DIVIDE = new BinaryFunction(){

        @Override
        public double value(double d, double d2) {
            return d / d2;
        }
    };
    public static final BinaryFunction POW = new BinaryFunction(){

        @Override
        public double value(double d, double d2) {
            return Math.pow(d, d2);
        }
    };
    public static final BinaryFunction ATAN2 = new BinaryFunction(){

        @Override
        public double value(double d, double d2) {
            return Math.atan2(d, d2);
        }
    };

    @Override
    public abstract double value(double var1, double var3) throws FunctionEvaluationException;

    public ComposableFunction fix1stArgument(final double d) {
        return new ComposableFunction(){

            @Override
            public double value(double d2) throws FunctionEvaluationException {
                return BinaryFunction.this.value(d, d2);
            }
        };
    }

    public ComposableFunction fix2ndArgument(final double d) {
        return new ComposableFunction(){

            @Override
            public double value(double d2) throws FunctionEvaluationException {
                return BinaryFunction.this.value(d2, d);
            }
        };
    }
}

