/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BinaryFunction;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;

public abstract class ComposableFunction
implements UnivariateRealFunction {
    public static final ComposableFunction ZERO = new ComposableFunction(){

        @Override
        public double value(double d) {
            return 0.0;
        }
    };
    public static final ComposableFunction ONE = new ComposableFunction(){

        @Override
        public double value(double d) {
            return 1.0;
        }
    };
    public static final ComposableFunction IDENTITY = new ComposableFunction(){

        @Override
        public double value(double d) {
            return d;
        }
    };
    public static final ComposableFunction ABS = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.abs(d);
        }
    };
    public static final ComposableFunction NEGATE = new ComposableFunction(){

        @Override
        public double value(double d) {
            return -d;
        }
    };
    public static final ComposableFunction INVERT = new ComposableFunction(){

        @Override
        public double value(double d) {
            return 1.0 / d;
        }
    };
    public static final ComposableFunction SIN = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.sin(d);
        }
    };
    public static final ComposableFunction SQRT = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.sqrt(d);
        }
    };
    public static final ComposableFunction SINH = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.sinh(d);
        }
    };
    public static final ComposableFunction EXP = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.exp(d);
        }
    };
    public static final ComposableFunction EXPM1 = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.expm1(d);
        }
    };
    public static final ComposableFunction ASIN = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.asin(d);
        }
    };
    public static final ComposableFunction ATAN = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.atan(d);
        }
    };
    public static final ComposableFunction TAN = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.tan(d);
        }
    };
    public static final ComposableFunction TANH = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.tanh(d);
        }
    };
    public static final ComposableFunction CBRT = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.cbrt(d);
        }
    };
    public static final ComposableFunction CEIL = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.ceil(d);
        }
    };
    public static final ComposableFunction FLOOR = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.floor(d);
        }
    };
    public static final ComposableFunction LOG = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.log(d);
        }
    };
    public static final ComposableFunction LOG10 = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.log10(d);
        }
    };
    public static final ComposableFunction LOG1P = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.log1p(d);
        }
    };
    public static final ComposableFunction COS = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.cos(d);
        }
    };
    public static final ComposableFunction ACOS = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.acos(d);
        }
    };
    public static final ComposableFunction COSH = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.cosh(d);
        }
    };
    public static final ComposableFunction RINT = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.rint(d);
        }
    };
    public static final ComposableFunction SIGNUM = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.signum(d);
        }
    };
    public static final ComposableFunction ULP = new ComposableFunction(){

        @Override
        public double value(double d) {
            return Math.ulp(d);
        }
    };

    public ComposableFunction of(final UnivariateRealFunction univariateRealFunction) {
        return new ComposableFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return ComposableFunction.this.value(univariateRealFunction.value(d));
            }
        };
    }

    public ComposableFunction postCompose(final UnivariateRealFunction univariateRealFunction) {
        return new ComposableFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return univariateRealFunction.value(ComposableFunction.this.value(d));
            }
        };
    }

    public ComposableFunction combine(final UnivariateRealFunction univariateRealFunction, final BivariateRealFunction bivariateRealFunction) {
        return new ComposableFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return bivariateRealFunction.value(ComposableFunction.this.value(d), univariateRealFunction.value(d));
            }
        };
    }

    public ComposableFunction add(final UnivariateRealFunction univariateRealFunction) {
        return new ComposableFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return ComposableFunction.this.value(d) + univariateRealFunction.value(d);
            }
        };
    }

    public ComposableFunction add(final double d) {
        return new ComposableFunction(){

            @Override
            public double value(double d2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(d2) + d;
            }
        };
    }

    public ComposableFunction subtract(final UnivariateRealFunction univariateRealFunction) {
        return new ComposableFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return ComposableFunction.this.value(d) - univariateRealFunction.value(d);
            }
        };
    }

    public ComposableFunction multiply(final UnivariateRealFunction univariateRealFunction) {
        return new ComposableFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return ComposableFunction.this.value(d) * univariateRealFunction.value(d);
            }
        };
    }

    public ComposableFunction multiply(final double d) {
        return new ComposableFunction(){

            @Override
            public double value(double d2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(d2) * d;
            }
        };
    }

    public ComposableFunction divide(final UnivariateRealFunction univariateRealFunction) {
        return new ComposableFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return ComposableFunction.this.value(d) / univariateRealFunction.value(d);
            }
        };
    }

    public MultivariateRealFunction asCollector(final BivariateRealFunction bivariateRealFunction, final double d) {
        return new MultivariateRealFunction(){

            @Override
            public double value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
                double d3 = d;
                for (double d2 : dArray) {
                    d3 = bivariateRealFunction.value(d3, ComposableFunction.this.value(d2));
                }
                return d3;
            }
        };
    }

    public MultivariateRealFunction asCollector(BivariateRealFunction bivariateRealFunction) {
        return this.asCollector(bivariateRealFunction, 0.0);
    }

    public MultivariateRealFunction asCollector(double d) {
        return this.asCollector(BinaryFunction.ADD, d);
    }

    public MultivariateRealFunction asCollector() {
        return this.asCollector(BinaryFunction.ADD, 0.0);
    }

    @Override
    public abstract double value(double var1) throws FunctionEvaluationException;
}

