/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.ContinuedFraction;

public class Beta {
    private static final double DEFAULT_EPSILON = 1.0E-14;

    private Beta() {
    }

    public static double regularizedBeta(double d, double d2, double d3) throws MathException {
        return Beta.regularizedBeta(d, d2, d3, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double d, double d2, double d3, double d4) throws MathException {
        return Beta.regularizedBeta(d, d2, d3, d4, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double d, double d2, double d3, int n) throws MathException {
        return Beta.regularizedBeta(d, d2, d3, 1.0E-14, n);
    }

    public static double regularizedBeta(double d, final double d2, final double d3, double d4, int n) throws MathException {
        double d5;
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || d < 0.0 || d > 1.0 || d2 <= 0.0 || d3 <= 0.0) {
            d5 = Double.NaN;
        } else if (d > (d2 + 1.0) / (d2 + d3 + 2.0)) {
            d5 = 1.0 - Beta.regularizedBeta(1.0 - d, d3, d2, d4, n);
        } else {
            ContinuedFraction continuedFraction = new ContinuedFraction(){

                @Override
                protected double getB(int n, double d) {
                    double d22;
                    if (n % 2 == 0) {
                        double d32 = (double)n / 2.0;
                        d22 = d32 * (d3 - d32) * d / ((d2 + 2.0 * d32 - 1.0) * (d2 + 2.0 * d32));
                    } else {
                        double d4 = ((double)n - 1.0) / 2.0;
                        d22 = -((d2 + d4) * (d2 + d3 + d4) * d) / ((d2 + 2.0 * d4) * (d2 + 2.0 * d4 + 1.0));
                    }
                    return d22;
                }

                @Override
                protected double getA(int n, double d) {
                    return 1.0;
                }
            };
            d5 = Math.exp(d2 * Math.log(d) + d3 * Math.log(1.0 - d) - Math.log(d2) - Beta.logBeta(d2, d3, d4, n)) * 1.0 / continuedFraction.evaluate(d, d4, n);
        }
        return d5;
    }

    public static double logBeta(double d, double d2) {
        return Beta.logBeta(d, d2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double logBeta(double d, double d2, double d3, int n) {
        double d4 = Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 <= 0.0 ? Double.NaN : Gamma.logGamma(d) + Gamma.logGamma(d2) - Gamma.logGamma(d + d2);
        return d4;
    }
}

