/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueBorderUtilities;
import blue.plaf.BlueIconFactory;
import blue.plaf.BlueTableBorder;
import blue.plaf.BlueTableHeaderBorder;
import blue.plaf.BlueTheme;
import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class BlueLookAndFeel
extends MetalLookAndFeel {
    static BlueTheme blueTheme;

    @Override
    public String getID() {
        return "Blue";
    }

    @Override
    public String getName() {
        return "Blue";
    }

    @Override
    public String getDescription() {
        return "Look and Feel for 'blue'";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        this.putDefault(table, "ButtonUI");
        this.putDefault(table, "ComboBoxUI");
        this.putDefault(table, "ToggleButtonUI");
        this.putDefault(table, "TabbedPaneUI");
        this.putDefault(table, "TableHeaderUI");
        this.putDefault(table, "TextFieldUI");
        this.putDefault(table, "MenuBarUI");
        this.putDefault(table, "ToolTipUI");
        this.putDefault(table, "SplitPaneUI");
        this.putDefault(table, "SliderUI");
        this.putDefault(table, "ToolBarUI");
        this.putDefault(table, "ScrollBarUI");
        this.putDefault(table, "ScrollPaneUI");
        this.putDefault(table, "TableUI");
    }

    protected void putDefault(UIDefaults table, String uiKey) {
        try {
            String className = "blue.plaf.Blue" + uiKey;
            table.put(uiKey, className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public UIDefaults getDefaults() {
        return super.getDefaults();
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        Object[] defaults = new Object[]{"CheckBox.icon", BlueIconFactory.getCheckBoxIcon(), "RadioButton.icon", BlueIconFactory.getRadioButtonIcon(), "Table.gridColor", new ColorUIResource(BlueLookAndFeel.getCurrentTheme().getControl()), "SplitPane.highlight", table.getColor("controlShadow"), "SplitPane.darkShadow", table.getColor("window"), "SplitPane.dividerSize", new Integer(5), "Table.cellNoFocusBorder", new EmptyBorder(7, 3, 7, 3), "Table.focusSelectedCellHighlightBorder", BorderFactory.createCompoundBorder(new LineBorder(BlueLookAndFeel.getCurrentTheme().getFocusColor()), new EmptyBorder(6, 2, 6, 2)), "Table.focusCellHighlightBorder", new EmptyBorder(7, 3, 7, 3), "TableHeader.cellBorder", new BlueTableBorder(), "ToolTip.foreground", new ColorUIResource(Color.black), "Button.border", BlueBorderUtilities.getButtonBorder(), "ToggleButton.border", BlueBorderUtilities.getToggleButtonBorder(), "TextField.border", BlueBorderUtilities.getTextFieldBorder(), "TableHeader.cellBorder", new BlueTableHeaderBorder(), "SplitPane.dividerSize", new Integer(6), "ScrollPane.border", BorderFactory.createLineBorder(BlueLookAndFeel.getCurrentTheme().getControl()), "ScrollPane.viewportBorder", null, "ScrollBar.width", 14, "ScrollBar.background", BlueLookAndFeel.getCurrentTheme().getControl().darker(), "ScrollBar.shadow", BlueLookAndFeel.getCurrentTheme().getControl().darker(), "ScrollBar.darkShadow", BlueLookAndFeel.getCurrentTheme().getControl().darker(), "Slider.horizontalThumbIcon", BlueIconFactory.getHorizontalSliderThumbIcon(), "Slider.verticalThumbIcon", BlueIconFactory.getVerticalSliderThumbIcon(), "Spinner.border", BlueBorderUtilities.getTextFieldBorder(), "Spinner.arrowButtonBorder", BlueBorderUtilities.getButtonBorder(), "Spinner.background", Color.BLACK};
        table.putDefaults(defaults);
    }

    private void setupForOSX(InputMap inputMap) {
        KeyStroke[] keys = inputMap.allKeys();
        if (keys == null) {
            return;
        }
        int menuShortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        for (int i = 0; i < keys.length; ++i) {
            boolean found = false;
            int modifiers = keys[i].getModifiers();
            if ((keys[i].getModifiers() & 0x80) == 128) {
                modifiers -= 128;
                found = true;
            }
            if ((keys[i].getModifiers() & 2) == 2) {
                modifiers -= 2;
                found = true;
            }
            if (!found) continue;
            KeyStroke keystroke = KeyStroke.getKeyStroke(keys[i].getKeyCode(), modifiers |= menuShortcutKey, keys[i].isOnKeyRelease());
            Object obj = inputMap.get(keys[i]);
            inputMap.remove(keys[i]);
            inputMap.put(keystroke, obj);
        }
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", this.getTranslucentColor(BlueLookAndFeel.getTextHighlightColor(), 128));
        table.put("text", BlueLookAndFeel.getBlack());
    }

    private Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color getGradientReflection() {
        return blueTheme.getGradientReflection();
    }

    public static Color getGradientShadow() {
        return blueTheme.getGradientShadow();
    }

    public static Color getGradientTranslucentReflection() {
        return blueTheme.getGradientTranslucentReflection();
    }

    public static Color getGradientTranslucentShadow() {
        return blueTheme.getGradientTranslucentShadow();
    }
}

